/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import guests.api.Shared;
import guests.api.UserPermissions;
import guests.domain.Application;
import guests.domain.ApplicationExists;
import guests.domain.Authority;
import guests.domain.ObjectExists;
import guests.domain.User;
import guests.exception.NotAllowedException;
import guests.exception.NotFoundException;
import guests.repository.ApplicationRepository;
import guests.repository.UserRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/applications"}, produces={"application/json"})
@Transactional
public class ApplicationController {
    private static final Log LOG = LogFactory.getLog(ApplicationController.class);
    private final ApplicationRepository applicationRepository;
    private final UserRepository userRepository;

    @Autowired
    public ApplicationController(ApplicationRepository applicationRepository, UserRepository userRepository) {
        this.applicationRepository = applicationRepository;
        this.userRepository = userRepository;
    }

    @GetMapping(value={"/user-count/{applicationId}"})
    public ResponseEntity<Long> userCount(@PathVariable(value="applicationId") Long applicationId, User authenticatedUser) {
        Long institutionId = ((Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(NotFoundException::new)).getInstitution().getId();
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institutionId, (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        return ResponseEntity.ok((Object)this.applicationRepository.countUsers(applicationId));
    }

    @GetMapping(value={"/user"})
    public ResponseEntity<List<Application>> getForUser(User authenticatedUser) {
        User user = (User)this.userRepository.findById((Object)authenticatedUser.getId()).orElseThrow(NotFoundException::new);
        List roleIdentifiers = user.getUserRoles().stream().map(role -> role.getRole().getId()).collect(Collectors.toList());
        return ResponseEntity.ok((Object)Shared.unProxy((Collection)this.applicationRepository.findByRoles_IdIn(roleIdentifiers), Application.class));
    }

    @GetMapping(value={"/institution/{institutionId}"})
    public ResponseEntity<List<Application>> getForInstitution(User authenticatedUser, @PathVariable(value="institutionId") Long institutionId) {
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institutionId, (Authority)Authority.INVITER);
        return ResponseEntity.ok((Object)this.applicationRepository.findByInstitution_id(institutionId.longValue()));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Application> getById(User authenticatedUser, @PathVariable(value="id") Long id) {
        Application application = (Application)this.applicationRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)application.getInstitution().getId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        return ResponseEntity.ok((Object)application);
    }

    @RequestMapping(method={RequestMethod.POST, RequestMethod.PUT})
    public ResponseEntity<Application> save(HttpServletRequest request, User authenticatedUser, @RequestBody Application application) {
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)application.getInstitution().getId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        application.validateProvisioning();
        LOG.info((Object)String.format("%s application %s by user %s", request.getMethod().equalsIgnoreCase("post") ? "Creating" : "Updating", application.getName(), authenticatedUser.getName()));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)((Application)this.applicationRepository.save((Object)application)));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Integer>> delete(User authenticatedUser, @PathVariable(value="id") Long id) {
        Application application = (Application)this.applicationRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)application.getInstitution().getId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        Long countUsers = this.applicationRepository.countUsers(application.getId());
        if (countUsers > 0L) {
            throw new NotAllowedException(String.format("Application %s can not be deleted as there are %s active users", application.getName(), countUsers));
        }
        this.applicationRepository.delete((Object)application);
        LOG.info((Object)String.format("Deleting application %s by user %s", application.getName(), authenticatedUser.getName()));
        return Shared.createdResponse();
    }

    @PostMapping(value={"entity-id-exists"})
    public ResponseEntity<Map<String, Boolean>> entityIdExists(User authenticatedUser, @RequestBody ApplicationExists applicationExists) {
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)applicationExists.getInstitutionId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        Optional optionalApplication = this.applicationRepository.findByInstitution_idAndEntityIdIgnoreCase(applicationExists.getInstitutionId(), applicationExists.getUniqueAttribute());
        return Shared.doesExists((ObjectExists)applicationExists, (Optional)optionalApplication);
    }
}

