/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import guests.api.Shared;
import guests.api.UserPermissions;
import guests.domain.Application;
import guests.domain.InstitutionMembership;
import guests.domain.User;
import guests.domain.UserRole;
import guests.exception.NotFoundException;
import guests.repository.ApplicationRepository;
import guests.repository.UserRepository;
import guests.scim.OperationType;
import guests.scim.SCIMService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/users"}, produces={"application/json"})
@Transactional
public class UserController {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private final UserRepository userRepository;
    private final ApplicationRepository applicationRepository;
    private final SCIMService scimService;

    @Autowired
    public UserController(UserRepository userRepository, ApplicationRepository applicationRepository, SCIMService scimService) {
        this.userRepository = userRepository;
        this.applicationRepository = applicationRepository;
        this.scimService = scimService;
    }

    @GetMapping(value={"me"})
    public ResponseEntity<User> me(User authenticatedUser) {
        User user = (User)this.userRepository.findById((Object)authenticatedUser.getId()).orElseThrow(NotFoundException::new);
        return ResponseEntity.ok((Object)user);
    }

    @GetMapping(value={"{userId}"})
    public ResponseEntity<User> other(User authenticatedUser, @PathVariable(value="userId") Long userId) {
        User other = (User)this.userRepository.findById((Object)userId).orElseThrow(NotFoundException::new);
        UserPermissions.viewOtherUserAllowed((User)authenticatedUser, (User)other);
        this.removeOtherInstitutionData(authenticatedUser, other);
        return ResponseEntity.ok((Object)other);
    }

    @GetMapping(value={"/institution/{institutionId}"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<User>> getByInstitution(User authenticatedUser, @PathVariable(value="institutionId") Long institutionId) {
        UserPermissions.verifyUser((User)authenticatedUser, (Long)institutionId);
        List users = this.userRepository.findByInstitutionMemberships_Institution_id(institutionId);
        this.removeOtherInstitutionData(authenticatedUser, institutionId, users);
        return ResponseEntity.ok((Object)users);
    }

    @GetMapping(value={"/emails/{institutionId}"})
    public ResponseEntity<List<Map<String, String>>> emailsByInstitution(User user, @PathVariable(value="institutionId") Long institutionId) {
        UserPermissions.verifyUser((User)user, (Long)institutionId);
        return ResponseEntity.ok((Object)this.userRepository.findEmailAndNameByInstitution_id(institutionId));
    }

    @GetMapping(value={"/application/{applicationId}"})
    public ResponseEntity<List<User>> getByApplication(User user, @PathVariable(value="applicationId") Long applicationId) {
        Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(NotFoundException::new);
        UserPermissions.verifyUser((User)user, (Long)application.getInstitution().getId());
        return ResponseEntity.ok((Object)this.userRepository.findByUserRoles_role_application_id(applicationId));
    }

    @DeleteMapping
    public ResponseEntity<Map<String, Integer>> delete(User authenticatedUser) {
        this.doDeleteUser(authenticatedUser);
        return Shared.createdResponse();
    }

    @DeleteMapping(value={"/{userId}"})
    public ResponseEntity<Map<String, Integer>> deleteOther(User authenticatedUser, @PathVariable(value="userId") Long userId) {
        User subject = (User)this.userRepository.findById((Object)userId).orElseThrow(NotFoundException::new);
        UserPermissions.deleteOtherUserAllowed((User)authenticatedUser, (User)subject);
        this.doDeleteUser(subject);
        return Shared.createdResponse();
    }

    @DeleteMapping(value={"/role/{userId}/{userRoleId}"})
    public ResponseEntity<Map<String, Integer>> deleteRoleForOther(User authenticatedUser, @PathVariable(value="userId") Long userId, @PathVariable(value="userRoleId") Long userRoleId) {
        User subject = (User)this.userRepository.findById((Object)userId).orElseThrow(NotFoundException::new);
        UserRole userRole = subject.getUserRoles().stream().filter(r -> r.getId().equals(userRoleId)).findFirst().orElseThrow(NotFoundException::new);
        UserPermissions.deleteUserRoleAllowed((User)authenticatedUser, (UserRole)userRole);
        subject.removeUserRole(userRole);
        this.userRepository.save((Object)subject);
        this.scimService.updateRoleRequest(userRole, OperationType.Remove);
        return Shared.createdResponse();
    }

    @DeleteMapping(value={"/membership/{userId}/{membershipId}"})
    public ResponseEntity<Map<String, Integer>> deleteMembershipForOther(User authenticatedUser, @PathVariable(value="userId") Long userId, @PathVariable(value="membershipId") Long membershipId) {
        User subject = (User)this.userRepository.findById((Object)userId).orElseThrow(NotFoundException::new);
        InstitutionMembership institutionMembership = subject.getInstitutionMemberships().stream().filter(m -> m.getId().equals(membershipId)).findFirst().orElseThrow(NotFoundException::new);
        UserPermissions.deleteInstitutionMembershipAllowed((User)authenticatedUser, (InstitutionMembership)institutionMembership);
        this.scimService.deleteUserByInstitutionRequest(subject, institutionMembership.getInstitution());
        Long institutionId = institutionMembership.getInstitution().getId();
        List<UserRole> userRoles = subject.getUserRoles().stream().filter(userRole -> userRole.getRole().getInstitutionId().equals(institutionId)).collect(Collectors.toList());
        userRoles.forEach(arg_0 -> ((User)subject).removeUserRole(arg_0));
        subject.removeMembership(institutionMembership);
        LOG.debug((Object)String.format("Deleting membership %s for user %s", institutionMembership.getAuthority(), subject.getName()));
        this.userRepository.save((Object)subject);
        return Shared.createdResponse();
    }

    private void doDeleteUser(User subject) {
        this.scimService.deleteUserRequest(subject);
        this.userRepository.delete((Object)subject);
        LOG.info((Object)String.format("Deleting user %s", subject.getName()));
    }

    private void removeOtherInstitutionData(User authenticatedUser, Long institutionId, List<User> users) {
        if (!authenticatedUser.isSuperAdmin()) {
            users.forEach(user -> user.removeOtherInstitutionData(institutionId));
        }
    }

    private void removeOtherInstitutionData(User authenticatedUser, User user) {
        if (!authenticatedUser.isSuperAdmin()) {
            user.removeOtherInstitutionData(authenticatedUser);
        }
    }
}

