/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import guests.domain.Authority;
import guests.domain.InstitutionMembership;
import guests.domain.User;
import guests.domain.UserRole;
import guests.exception.UserRestrictionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserPermissions {
    private UserPermissions() {
    }

    public static void verifyUser(User authenticatedUser, Long institutionId) {
        if (!authenticatedUser.isSuperAdmin()) {
            authenticatedUser.authorityByInstitution(institutionId).orElseThrow(() -> UserPermissions.userRestrictedException((User)authenticatedUser, (Long)institutionId));
        }
    }

    public static void verifySuperUser(User user) {
        if (!user.isSuperAdmin()) {
            throw new UserRestrictionException("Authority mismatch");
        }
    }

    public static void verifyAuthority(User user, Long institutionId, Authority required) {
        Authority authority;
        if (!user.isSuperAdmin() && !(authority = (Authority)user.authorityByInstitution(institutionId).orElseThrow(() -> UserPermissions.userRestrictedException((User)user, (Long)institutionId))).hasEqualOrHigherRights(required)) {
            throw UserPermissions.userRestrictedException((User)user, (Long)institutionId);
        }
    }

    public static void viewOtherUserAllowed(User authenticatedUser, User subject) {
        boolean allowed;
        if (!(authenticatedUser.isSuperAdmin() || authenticatedUser.getId().equals(subject.getId()) || (allowed = authenticatedUser.getInstitutionMemberships().stream().anyMatch(membership -> subject.getInstitutionMemberships().stream().anyMatch(subjectMembership -> subjectMembership.getInstitution().getId().equals(membership.getInstitution().getId()) && membership.getAuthority().hasHigherRights(subjectMembership.getAuthority())))))) {
            throw UserPermissions.userRestrictedException((User)authenticatedUser, (User)subject);
        }
    }

    public static void deleteOtherUserAllowed(User authenticatedUser, User subject) {
        boolean allowed;
        if (!(authenticatedUser.isSuperAdmin() || authenticatedUser.getId().equals(subject.getId()) || (allowed = subject.getInstitutionMemberships().stream().allMatch(subjectMembership -> authenticatedUser.getInstitutionMemberships().stream().anyMatch(membership -> membership.getInstitution().getId().equals(subjectMembership.getInstitution().getId()) && membership.getAuthority().hasHigherRights(subjectMembership.getAuthority())))))) {
            throw UserPermissions.userRestrictedException((User)authenticatedUser, (User)subject);
        }
    }

    public static void deleteUserRoleAllowed(User authenticatedUser, UserRole subjectUserRole) {
        User subject = subjectUserRole.getUser();
        Long institutionId = subjectUserRole.getRole().getApplication().getInstitution().getId();
        Authority highestAuthority = subject.getInstitutionMemberships().stream().map(InstitutionMembership::getAuthority).max(Authority::compareRights).orElse(Authority.GUEST);
        UserPermissions.doDeleteUserRoleOrMembershipAllowed((User)authenticatedUser, (User)subject, (Long)institutionId, (Authority)highestAuthority);
    }

    public static void deleteInstitutionMembershipAllowed(User authenticatedUser, InstitutionMembership institutionMembership) {
        User subject = institutionMembership.getUser();
        Long institutionId = institutionMembership.getInstitution().getId();
        UserPermissions.doDeleteUserRoleOrMembershipAllowed((User)authenticatedUser, (User)subject, (Long)institutionId, (Authority)institutionMembership.getAuthority());
    }

    public static UserRestrictionException userRestrictedException(User authenticatedUser, Long institutionId) {
        return new UserRestrictionException(String.format("User %s is not allowed to act for institution %s", authenticatedUser.getEduPersonPrincipalName(), institutionId));
    }

    public static UserRestrictionException userRestrictedException(User authenticatedUser, User subject) {
        return new UserRestrictionException(String.format("User %s is not allowed to act for user %s", authenticatedUser.getEduPersonPrincipalName(), subject.getEduPersonPrincipalName()));
    }

    private static void doDeleteUserRoleOrMembershipAllowed(User authenticatedUser, User subject, Long institutionId, Authority authority) {
        boolean allowed;
        if (!(authenticatedUser.isSuperAdmin() || authenticatedUser.getId().equals(subject.getId()) || (allowed = authenticatedUser.getInstitutionMemberships().stream().anyMatch(membership -> membership.getInstitution().getId().equals(institutionId) && membership.getAuthority().hasHigherRights(authority))))) {
            throw UserPermissions.userRestrictedException((User)authenticatedUser, (User)subject);
        }
    }
}

