/*
 * Decompiled with CFR 0.152.
 */
package guests.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import guests.domain.Auditable;
import guests.domain.Institution;
import guests.domain.NameHolder;
import guests.domain.NameHolderListener;
import guests.domain.Role;
import guests.exception.InvalidProvisioningException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.LazyInitializationException;
import org.springframework.util.StringUtils;

@Entity(name="applications")
@EntityListeners(value={NameHolderListener.class})
public class Application
implements Serializable,
NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String name;
    @Column(name="display_name")
    private String displayName;
    @Column(name="entity_id")
    @NotNull
    private String entityId;
    @Column(name="landing_page")
    @NotNull
    private String landingPage;
    @Column(name="provisioning_hook_url")
    private String provisioningHookUrl;
    @Column(name="provisioning_hook_username")
    private String provisioningHookUsername;
    @Column(name="provisioning_hook_password")
    private String provisioningHookPassword;
    @Column(name="provisioning_hook_email")
    private String provisioningHookEmail;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="institution_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Institution institution;
    @OneToMany(mappedBy="application", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<Role> roles = new HashSet();
    @Column(name="update_role_put_method")
    private boolean updateRolePutMethod;
    @Embedded
    private Auditable auditable = new Auditable();

    public Application(Institution institution) {
        this.institution = institution;
    }

    public Application(Institution institution, String entityId, String landingPage, String provisioningHookUrl, String provisioningHookUsername, String provisioningHookPassword) {
        this.institution = institution;
        this.entityId = entityId;
        this.landingPage = landingPage;
        this.name = entityId;
        this.provisioningHookUrl = provisioningHookUrl;
        this.provisioningHookUsername = provisioningHookUsername;
        this.provisioningHookPassword = provisioningHookPassword;
    }

    @JsonProperty(value="institution", access=JsonProperty.Access.READ_ONLY)
    public Map<String, Object> getInstitutionMap() {
        try {
            Institution institution = this.getInstitution();
            HashMap<String, Object> institutionMap = new HashMap<String, Object>();
            institutionMap.put("id", institution.getId());
            institutionMap.put("homeInstitution", institution.getHomeInstitution());
            institutionMap.put("displayName", institution.getDisplayName());
            return institutionMap;
        }
        catch (LazyInitializationException e) {
            return null;
        }
    }

    @JsonIgnore
    public void nameUrnCompatibilityCheck() {
        this.name = this.compatibleUrnName(this.name);
    }

    @JsonIgnore
    public void validateProvisioning() {
        if (!(!StringUtils.hasText((String)this.provisioningHookUrl) || StringUtils.hasText((String)this.provisioningHookUsername) && StringUtils.hasText((String)this.provisioningHookPassword))) {
            throw new InvalidProvisioningException("provisioningHookUsername and provisioningHookPassword are required when provisioningHookUrl is configured");
        }
        if (StringUtils.hasText((String)this.provisioningHookUrl) && StringUtils.hasText((String)this.provisioningHookEmail)) {
            throw new InvalidProvisioningException("Can not specify both provisioningHookUrl and provisioningHookEmail");
        }
    }

    @JsonIgnore
    public void addRole(Role role) {
        this.roles.add(role);
        role.setApplication(this);
    }

    @JsonIgnore
    public boolean provisioningEnabled() {
        return StringUtils.hasText((String)this.provisioningHookUrl) || StringUtils.hasText((String)this.provisioningHookEmail);
    }

    public String toString() {
        return "Application{name='" + this.name + "', entityId='" + this.entityId + "}";
    }

    @Generated
    public Application() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getLandingPage() {
        return this.landingPage;
    }

    @Generated
    public String getProvisioningHookUrl() {
        return this.provisioningHookUrl;
    }

    @Generated
    public String getProvisioningHookUsername() {
        return this.provisioningHookUsername;
    }

    @Generated
    public String getProvisioningHookPassword() {
        return this.provisioningHookPassword;
    }

    @Generated
    public String getProvisioningHookEmail() {
        return this.provisioningHookEmail;
    }

    @Generated
    public Institution getInstitution() {
        return this.institution;
    }

    @Generated
    public Set<Role> getRoles() {
        return this.roles;
    }

    @Generated
    public boolean isUpdateRolePutMethod() {
        return this.updateRolePutMethod;
    }

    @Generated
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setLandingPage(String landingPage) {
        this.landingPage = landingPage;
    }

    @Generated
    public void setProvisioningHookUrl(String provisioningHookUrl) {
        this.provisioningHookUrl = provisioningHookUrl;
    }

    @Generated
    public void setProvisioningHookUsername(String provisioningHookUsername) {
        this.provisioningHookUsername = provisioningHookUsername;
    }

    @Generated
    public void setProvisioningHookPassword(String provisioningHookPassword) {
        this.provisioningHookPassword = provisioningHookPassword;
    }

    @Generated
    public void setProvisioningHookEmail(String provisioningHookEmail) {
        this.provisioningHookEmail = provisioningHookEmail;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    @Generated
    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    @Generated
    public void setUpdateRolePutMethod(boolean updateRolePutMethod) {
        this.updateRolePutMethod = updateRolePutMethod;
    }

    @Generated
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }
}

