/*
 * Decompiled with CFR 0.152.
 */
package guests.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;

@Embeddable
public class Auditable
implements Serializable {
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Instant updatedAt;
    @Column(name="updated_by")
    private String updatedBy;

    @PrePersist
    public void prePersist() {
        this.createdAt = Instant.now();
        this.createdBy = this.currentUser();
    }

    @PreUpdate
    public void preUpdate() {
        this.updatedAt = Instant.now();
        this.updatedBy = this.currentUser();
    }

    @JsonIgnore
    private String currentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof BearerTokenAuthentication) {
            BearerTokenAuthentication bearerTokenAuthentication = (BearerTokenAuthentication)authentication;
            return (String)bearerTokenAuthentication.getTokenAttributes().get("eduperson_principal_name");
        }
        return authentication.getName();
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }
}

