/*
 * Decompiled with CFR 0.152.
 */
package guests.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import guests.domain.Institution;
import guests.domain.User;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import lombok.Generated;
import org.hibernate.LazyInitializationException;

@Entity(name="aups")
public class Aup
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="institution_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Institution institution;
    @Column(name="agreed_at")
    private Instant agreedAt;
    @Column
    private Integer version;
    @Column
    private String url;

    public Aup(Institution institution) {
        this.institution = institution;
        this.agreedAt = Instant.now();
        this.version = institution.getAupVersion();
        this.url = institution.getAupUrl();
    }

    @JsonProperty(value="institution", access=JsonProperty.Access.READ_ONLY)
    public Map<String, Object> getInstitutionMap() {
        try {
            Institution institution = this.getInstitution();
            HashMap<String, Object> institutionMap = new HashMap<String, Object>();
            institutionMap.put("id", institution.getId());
            institutionMap.put("name", institution.getDisplayName());
            return institutionMap;
        }
        catch (LazyInitializationException e) {
            return null;
        }
    }

    @Generated
    public Aup() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public Institution getInstitution() {
        return this.institution;
    }

    @Generated
    public Instant getAgreedAt() {
        return this.agreedAt;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    @Generated
    public void setAgreedAt(Instant agreedAt) {
        this.agreedAt = agreedAt;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }
}

