/*
 * Decompiled with CFR 0.152.
 */
package guests.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import guests.domain.Authority;
import guests.domain.Institution;
import guests.domain.InvitationRole;
import guests.domain.Status;
import guests.domain.User;
import java.io.Serializable;
import java.time.Instant;
import java.time.Period;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Entity(name="invitations")
public class Invitation
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="intended_authority")
    private Authority intendedAuthority;
    @Enumerated(value=EnumType.STRING)
    private Status status;
    @Column
    private String email;
    @Column
    private String message;
    @Column
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String hash;
    @Column(name="enforce_email_equality")
    private boolean enforceEmailEquality;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="expiry_date")
    private Instant expiryDate;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="inviter_id")
    @JsonIgnore
    private User inviter;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="institution_id")
    private Institution institution;
    @OneToMany(mappedBy="invitation", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<InvitationRole> roles = new HashSet();
    @Transient
    private boolean emailEqualityConflict = false;

    public Invitation(Authority intendedAuthority, String message, String email, boolean enforceEmailEquality, Set<InvitationRole> roles) {
        this.intendedAuthority = intendedAuthority;
        this.message = message;
        this.enforceEmailEquality = enforceEmailEquality;
        this.status = Status.OPEN;
        this.roles = roles;
        this.email = email;
        roles.forEach(role -> role.setInvitation(this));
        this.defaults();
    }

    public Invitation(Authority intendedAuthority, Status status, String hash, User inviter, Institution institution, String email) {
        this.intendedAuthority = intendedAuthority;
        this.status = status;
        this.hash = hash;
        this.inviter = inviter;
        this.email = email;
        this.institution = institution;
        this.defaults();
    }

    public void defaults() {
        this.expiryDate = Instant.now().plus(Period.ofDays(14));
        this.createdAt = Instant.now();
    }

    @JsonIgnore
    public void addInvitationRole(InvitationRole role) {
        this.roles.add(role);
        role.setInvitation(this);
    }

    @JsonIgnore
    public List<String> anyRoles() {
        return CollectionUtils.isEmpty((Collection)this.roles) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonProperty(value="inviter", access=JsonProperty.Access.READ_ONLY)
    public Map<String, String> getInviterEmail() {
        User inviter = this.getInviter();
        return inviter != null ? Map.of("email", inviter.getEmail(), "name", inviter.getName()) : Collections.emptyMap();
    }

    @Generated
    public Invitation() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Authority getIntendedAuthority() {
        return this.intendedAuthority;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public boolean isEnforceEmailEquality() {
        return this.enforceEmailEquality;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    @Generated
    public User getInviter() {
        return this.inviter;
    }

    @Generated
    public Institution getInstitution() {
        return this.institution;
    }

    @Generated
    public Set<InvitationRole> getRoles() {
        return this.roles;
    }

    @Generated
    public boolean isEmailEqualityConflict() {
        return this.emailEqualityConflict;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIntendedAuthority(Authority intendedAuthority) {
        this.intendedAuthority = intendedAuthority;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setEnforceEmailEquality(boolean enforceEmailEquality) {
        this.enforceEmailEquality = enforceEmailEquality;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setExpiryDate(Instant expiryDate) {
        this.expiryDate = expiryDate;
    }

    @JsonIgnore
    @Generated
    public void setInviter(User inviter) {
        this.inviter = inviter;
    }

    @Generated
    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    @Generated
    public void setRoles(Set<InvitationRole> roles) {
        this.roles = roles;
    }

    @Generated
    public void setEmailEqualityConflict(boolean emailEqualityConflict) {
        this.emailEqualityConflict = emailEqualityConflict;
    }
}

