/*
 * Decompiled with CFR 0.152.
 */
package guests.mail;

import guests.cron.IdPMetaDataResolver;
import guests.mail.MailBox;
import guests.mail.MockMailBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    @Value(value="${email.from}")
    private String emailFrom;
    @Value(value="${email.base-url}")
    private String baseUrl;
    @Value(value="${email.scim-failure}")
    private String scimFailureEmail;
    @Value(value="${email.environment}")
    private String environment;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private IdPMetaDataResolver metaDataResolver;

    @Bean
    @Profile(value={"!test", "!dev"})
    public MailBox mailSenderProd() {
        return new MailBox(this.mailSender, this.metaDataResolver, this.emailFrom, this.baseUrl, this.scimFailureEmail, this.environment);
    }

    @Bean
    @Profile(value={"test", "dev"})
    @Primary
    public MailBox mailSenderDev() {
        return new MockMailBox(this.mailSender, this.metaDataResolver, this.emailFrom, this.baseUrl, this.scimFailureEmail, this.environment);
    }
}

