/*
 * Decompiled with CFR 0.152.
 */
package guests.repository;

import guests.domain.User;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, Long> {
    @EntityGraph(value="findByEduPersonPrincipalNameIgnoreCase", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"userRoles.role.application"})
    public Optional<User> findByEduPersonPrincipalNameIgnoreCase(String var1);

    public Optional<User> findBySubIgnoreCase(String var1);

    public List<User> findByInstitutionMemberships_Institution_id(Long var1);

    public List<User> findByUserRoles_role_application_id(Long var1);

    public List<User> findByLastActivityBefore(Instant var1);

    @Query(value="select u.email, u.given_name, u.family_name from users u inner join institution_memberships m on m.user_id = u.id where m.institution_id = ?1 and m.authority = 'GUEST'", nativeQuery=true)
    public List<Map<String, String>> findEmailAndNameByInstitution_id(Long var1);
}

