/*
 * Decompiled with CFR 0.152.
 */
package guests.scim;

import guests.domain.ServiceProviderIdentifier;
import guests.domain.User;
import guests.scim.Email;
import guests.scim.Name;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class UserRequest
implements Serializable {
    private final List<String> schemas = Collections.singletonList("urn:ietf:params:scim:schemas:core:2.0:User");
    private final String externalId;
    private final String userName;
    private final Name name;
    private String id;
    private final String displayName;
    private final List<Email> emails;

    public UserRequest(User user) {
        this.externalId = user.getEduPersonPrincipalName();
        this.userName = user.getEduPersonPrincipalName();
        this.name = new Name(user.getFamilyName(), user.getGivenName());
        this.displayName = String.format("%s %s", user.getGivenName(), user.getFamilyName());
        this.emails = Collections.singletonList(new Email(user.getEmail()));
    }

    public UserRequest(User user, ServiceProviderIdentifier serviceProviderIdentifier) {
        this(user);
        this.id = serviceProviderIdentifier.getServiceProviderId();
    }

    @Generated
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Name getName() {
        return this.name;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public List<Email> getEmails() {
        return this.emails;
    }
}

