/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import guests.api.Shared;
import guests.api.UserPermissions;
import guests.domain.Authority;
import guests.domain.Institution;
import guests.domain.ObjectExists;
import guests.domain.User;
import guests.exception.NotAllowedException;
import guests.exception.NotFoundException;
import guests.repository.InstitutionRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/institutions"}, produces={"application/json"})
@Transactional
public class InstitutionController {
    private static final Log LOG = LogFactory.getLog(InstitutionController.class);
    private final InstitutionRepository institutionRepository;

    @Autowired
    public InstitutionController(InstitutionRepository institutionRepository) {
        this.institutionRepository = institutionRepository;
    }

    @GetMapping
    public ResponseEntity<List<Institution>> get(User user) {
        UserPermissions.verifySuperUser((User)user);
        return ResponseEntity.ok((Object)this.institutionRepository.findAll());
    }

    @GetMapping(value={"/mine"})
    public ResponseEntity<List<Institution>> mine(User user) {
        return ResponseEntity.ok((Object)this.institutionRepository.findByInstitutionMemberships_user_id(user.getId()));
    }

    @GetMapping(value={"/user-count/{institutionId}"})
    public ResponseEntity<Long> userCount(@PathVariable(value="institutionId") Long institutionId, User user) {
        UserPermissions.verifyUser((User)user, (Long)institutionId);
        return ResponseEntity.ok((Object)this.institutionRepository.countUsers(institutionId));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Institution> getById(User user, @PathVariable(value="id") Long id) {
        UserPermissions.verifyUser((User)user, (Long)id);
        Institution institution = (Institution)this.institutionRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        return ResponseEntity.ok((Object)institution);
    }

    @PostMapping(value={"entity-id-exists"})
    public ResponseEntity<Map<String, Boolean>> entityIdExists(User user, @RequestBody ObjectExists objectExists) {
        UserPermissions.verifySuperUser((User)user);
        Optional optionalInstitution = this.institutionRepository.findByEntityIdIgnoreCase(objectExists.getUniqueAttribute());
        return Shared.doesExists((ObjectExists)objectExists, (Optional)optionalInstitution);
    }

    @PostMapping(value={"schac-home-exists"})
    public ResponseEntity<Map<String, Boolean>> schacHomeExists(User user, @RequestBody ObjectExists objectExists) {
        UserPermissions.verifySuperUser((User)user);
        Optional optionalInstitution = this.institutionRepository.findByHomeInstitutionIgnoreCase(objectExists.getUniqueAttribute());
        return Shared.doesExists((ObjectExists)objectExists, (Optional)optionalInstitution);
    }

    @PostMapping
    public ResponseEntity<Institution> save(User user, @RequestBody Institution institution) {
        UserPermissions.verifySuperUser((User)user);
        institution.invariantAupVersion();
        LOG.info((Object)String.format("Saving new institution %s by user %s", institution.getHomeInstitution(), user.getName()));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)((Institution)this.institutionRepository.save((Object)institution)));
    }

    @PutMapping
    public ResponseEntity<Institution> update(User user, @RequestBody Institution institution) {
        UserPermissions.verifyAuthority((User)user, (Long)institution.getId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        Institution institutionFromDb = (Institution)this.institutionRepository.findById((Object)institution.getId()).orElseThrow(NotFoundException::new);
        if (!user.isSuperAdmin()) {
            institution.setHomeInstitution(institutionFromDb.getHomeInstitution());
            institution.setEntityId(institutionFromDb.getEntityId());
        }
        institution.invariantAupVersion();
        LOG.info((Object)String.format("Updating institution %s by user %s", institution.getHomeInstitution(), user.getName()));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)((Institution)this.institutionRepository.save((Object)institution)));
    }

    @PutMapping(value={"increment-aup/{id}"})
    public ResponseEntity<Map<String, Integer>> incrementAup(User authenticatedUser, @PathVariable(value="id") Long id) {
        Institution institution = (Institution)this.institutionRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)id, (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        institution.incrementAup();
        this.institutionRepository.save((Object)institution);
        LOG.debug((Object)String.format("Incrementing AUP for institution %s by user %s", institution.getHomeInstitution(), authenticatedUser.getName()));
        return Shared.createdResponse();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Integer>> delete(User user, @PathVariable(value="id") Long id) {
        UserPermissions.verifySuperUser((User)user);
        Institution institution = (Institution)this.institutionRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        Long countUsers = this.institutionRepository.countUsers(institution.getId());
        if (countUsers > 0L) {
            throw new NotAllowedException(String.format("Institution %s can not be deleted as there are %s active users", institution.getHomeInstitution(), countUsers));
        }
        this.institutionRepository.delete((Object)institution);
        LOG.info((Object)String.format("Deleting Institution %s by user %s", institution.getHomeInstitution(), user.getName()));
        return Shared.createdResponse();
    }
}

