/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v1/public"}, produces={"application/json"})
public class PublicController {
    private final String authorizationUrl;
    private final String tokenUrl;
    private final String relyingParty;
    private final String redirectUri;

    public PublicController(@Value(value="${oidc.authorization_uri}") String authorizationUrl, @Value(value="${oidc.token_uri}") String tokenUrl, @Value(value="${oidc.relying_party_id}") String relyingParty, @Value(value="${oidc.client_redirect_uri}") String redirectUri) {
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
        this.relyingParty = relyingParty;
        this.redirectUri = redirectUri;
    }

    @PostMapping(value={"/authorize"})
    public ResponseEntity<Map<String, String>> authorize() {
        CodeVerifier codeVerifier = new CodeVerifier();
        CodeChallenge codeChallenge = CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.S256, (CodeVerifier)codeVerifier);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("response_type", "code");
        parameters.put("scope", "openid");
        parameters.put("client_id", this.relyingParty);
        parameters.put("redirect_uri", this.redirectUri);
        parameters.put("nonce", UUID.randomUUID().toString());
        parameters.put("code_challenge", codeChallenge.getValue());
        parameters.put("code_challenge_method", CodeChallengeMethod.S256.getValue());
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.authorizationUrl);
        parameters.forEach((key, value) -> builder.queryParam(key, new Object[]{this.encode(value)}));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("grantType", "authorization_code");
        results.put("codeChallengeMethod", CodeChallengeMethod.S256.getValue());
        results.put("redirectUri", this.redirectUri);
        results.put("authorizationUrl", builder.build().toUriString());
        results.put("tokenUrl", this.tokenUrl);
        results.put("clientId", this.relyingParty);
        results.put("codeVerifier", codeVerifier.getValue());
        return ResponseEntity.ok(results);
    }

    private String encode(String s) {
        return URLEncoder.encode(s, Charset.defaultCharset().toString());
    }
}

