/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import guests.domain.Validation;
import guests.validation.EmailFormatValidator;
import guests.validation.FormatValidator;
import guests.validation.URLFormatValidator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/validations"}, produces={"application/json"})
@Transactional
public class ValidationController {
    private final Map<String, FormatValidator> validators = Stream.of(new EmailFormatValidator(), new URLFormatValidator()).collect(Collectors.toMap(FormatValidator::formatName, Function.identity()));

    @PostMapping(value={"validate"})
    public ResponseEntity<Map<String, Boolean>> validate(@RequestBody Validation validation) {
        boolean valid = this.validators.computeIfAbsent(validation.getType(), key -> {
            throw new IllegalArgumentException(String.format("No validation defined for %s", key));
        }).isValid(validation.getValue());
        return ResponseEntity.ok(Collections.singletonMap("valid", valid));
    }
}

