/*
 * Decompiled with CFR 0.152.
 */
package guests.cron;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class IdPMetaDataResolver {
    private static final Log LOG = LogFactory.getLog(IdPMetaDataResolver.class);
    private final Resource metaDataResource;
    private Map<String, String> logoMap = new HashMap();

    @Autowired
    public IdPMetaDataResolver(@Value(value="${cron.metadata-resolver-url}") Resource metaDataResource) {
        this.metaDataResource = metaDataResource;
    }

    @Scheduled(initialDelayString="${cron.metadata-resolver-initial-delay-milliseconds}", fixedRateString="${cron.metadata-resolver-fixed-rate-milliseconds}")
    public void resolveIdpMetaData() {
        long start = System.currentTimeMillis();
        HashMap<String, String> newLogoMap = new HashMap<String, String>();
        try {
            XMLStreamReader reader = this.getXMLStreamReader(this.metaDataResource);
            String entityId = null;
            while (reader.hasNext()) {
                if (reader.next() != 1) continue;
                String localName = reader.getLocalName();
                if ("EntityDescriptor".equals(localName)) {
                    entityId = reader.getAttributeValue(null, "entityID");
                    continue;
                }
                if (!"Logo".equals(localName)) continue;
                String logo = reader.getElementText();
                if (!StringUtils.hasText((String)entityId) || !StringUtils.hasText((String)logo)) continue;
                newLogoMap.put(entityId, logo.trim().replaceAll("\\n\\t ", ""));
            }
            this.logoMap = newLogoMap;
            LOG.info((Object)String.format("Parsed %s institution logo's from %s in %s ms", this.logoMap.size(), this.metaDataResource.getDescription(), System.currentTimeMillis() - start));
        }
        catch (FileNotFoundException fe) {
            LOG.warn((Object)String.format("Could not read IdP Metadata from %s", this.metaDataResource.getDescription()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error in resolveIdpMetaData", (Throwable)e);
        }
    }

    public Optional<String> getLogo(String institutionEntityId) {
        String logo;
        if (this.logoMap.isEmpty()) {
            this.resolveIdpMetaData();
        }
        if (!StringUtils.hasText((String)(logo = (String)this.logoMap.get(institutionEntityId)))) {
            LOG.warn((Object)("Missing logo for entityID: " + institutionEntityId));
        }
        return Optional.ofNullable(logo);
    }

    private XMLStreamReader getXMLStreamReader(Resource xml) throws IOException, XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlInputFactory.createXMLStreamReader(xml.getInputStream());
    }
}

