/*
 * Decompiled with CFR 0.152.
 */
package guests.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import guests.domain.Application;
import guests.domain.Aup;
import guests.domain.Authority;
import guests.domain.Institution;
import guests.domain.InstitutionMembership;
import guests.domain.UserRole;
import guests.exception.NotFoundException;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.util.StringUtils;

@Entity(name="users")
public class User
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="eduperson_principal_name")
    @NotNull
    private String eduPersonPrincipalName;
    @Column(name="sub")
    @NotNull
    private String sub;
    @Column(name="given_name")
    private String givenName;
    @Column(name="family_name")
    private String familyName;
    @Column
    private String email;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="last_activity")
    private Instant lastActivity = Instant.now();
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<Aup> aups = new HashSet();
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<UserRole> userRoles = new HashSet();
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<InstitutionMembership> institutionMemberships = new HashSet();

    public User(Institution institution, Authority authority, Map<String, Object> tokenAttributes) {
        this(authority, (String)tokenAttributes.get("eduperson_principal_name"), (String)tokenAttributes.get("sub"), (String)tokenAttributes.get("given_name"), (String)tokenAttributes.get("family_name"), (String)tokenAttributes.get("email"), institution);
    }

    public User(Authority authority, String eppn, String sub, String givenName, String familyName, String email, Institution institution) {
        this.eduPersonPrincipalName = eppn;
        this.sub = sub;
        this.givenName = givenName;
        this.familyName = familyName;
        this.email = email;
        this.addMembership(new InstitutionMembership(authority, institution));
        this.createdAt = Instant.now();
    }

    private User(String givenName, String familyName, String email) {
        this.givenName = givenName;
        this.familyName = familyName;
        this.email = email;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return String.format("%s %s", this.givenName, this.familyName);
    }

    @JsonIgnore
    public void addUserRole(UserRole role) {
        this.userRoles.add(role);
        role.setUser(this);
    }

    @JsonIgnore
    public void removeUserRole(UserRole role) {
        Set newRoles = this.userRoles.stream().filter(ur -> !ur.getId().equals(role.getId())).collect(Collectors.toSet());
        this.userRoles.clear();
        this.userRoles.addAll(newRoles);
    }

    @JsonIgnore
    public void addMembership(InstitutionMembership membership) {
        this.institutionMemberships.add(membership);
        membership.setUser(this);
    }

    @JsonIgnore
    public void removeMembership(InstitutionMembership membership) {
        Set newMemberships = this.institutionMemberships.stream().filter(m -> !m.getId().equals(membership.getId())).collect(Collectors.toSet());
        this.institutionMemberships.clear();
        this.institutionMemberships.addAll(newMemberships);
    }

    @JsonIgnore
    public void addAup(Aup aup) {
        this.aups.add(aup);
        aup.setUser(this);
    }

    @JsonIgnore
    public boolean hasChanged(Map<String, Object> tokenAttributes) {
        boolean changed;
        User user = new User((String)tokenAttributes.get("given_name"), (String)tokenAttributes.get("family_name"), (String)tokenAttributes.get("email"));
        boolean bl = changed = !this.toScimString().equals(user.toScimString());
        if (changed) {
            this.familyName = user.familyName;
            this.givenName = user.givenName;
            this.email = user.email;
        }
        return changed;
    }

    @JsonIgnore
    public Optional<Authority> authorityByInstitution(Long institutionId) {
        return this.institutionMemberships.stream().filter(membership -> membership.getInstitution().getId().equals(institutionId)).map(membership -> membership.getAuthority()).findFirst();
    }

    @JsonIgnore
    public boolean isSuperAdmin() {
        return this.institutionMemberships.stream().anyMatch(membership -> membership.getAuthority().equals((Object)Authority.SUPER_ADMIN));
    }

    @JsonIgnore
    public boolean hasAgreedWithAup(Institution institution) {
        return !StringUtils.hasText((String)institution.getAupUrl()) || this.aups.stream().anyMatch(aup -> aup.getInstitution().getId().equals(institution.getId()) && aup.getVersion().equals(institution.getAupVersion()));
    }

    @JsonIgnore
    private Application findApplication(Long id) {
        return this.userRoles.stream().map(userRole -> userRole.getRole().getApplication()).filter(application -> application.getId().equals(id)).findFirst().orElseThrow(NotFoundException::new);
    }

    @JsonIgnore
    public Map<Application, List<UserRole>> userRolesPerApplicationProvisioningEnabled() {
        Map<Long, List<UserRole>> userRolesPerApplicationId = this.getUserRoles().stream().filter(userRole -> userRole.getRole() != null && userRole.getRole().getApplication() != null).collect(Collectors.groupingBy(userRole -> userRole.getRole().getApplication().getId()));
        Map<Application, List<UserRole>> result = userRolesPerApplicationId.entrySet().stream().collect(Collectors.toMap(entry -> this.findApplication((Long)entry.getKey()), Map.Entry::getValue));
        result.keySet().removeIf(application -> !application.scimProvisioningEnabled());
        Set uniqueAppIdentifiers = result.keySet().stream().collect(Collectors.groupingBy(application -> application.getInstitution().getId())).values().stream().map(apps -> ((Application)apps.get(0)).getId()).collect(Collectors.toSet());
        result.keySet().removeIf(application -> !uniqueAppIdentifiers.contains(application.getId()));
        return result;
    }

    @JsonIgnore
    public void removeOtherInstitutionData(Long institutionId) {
        this.getInstitutionMemberships().removeIf(membership -> !membership.getInstitution().getId().equals(institutionId));
        this.getUserRoles().removeIf(userRole -> !userRole.getRole().getInstitutionId().equals(institutionId));
    }

    @JsonIgnore
    public void removeOtherInstitutionData(User authenticatedUser) {
        Set institutionIdentifiers = authenticatedUser.getInstitutionMemberships().stream().filter(membership -> membership.getAuthority().hasEqualOrHigherRights(this.institutionMemberships.stream().filter(m -> m.getInstitution().getId().equals(membership.getInstitution().getId())).map(m -> m.getAuthority()).findFirst().orElse(Authority.GUEST))).map(membership -> membership.getInstitution().getId()).collect(Collectors.toSet());
        this.getInstitutionMemberships().removeIf(membership -> !institutionIdentifiers.contains(membership.getInstitution().getId()));
        this.getUserRoles().removeIf(userRole -> !institutionIdentifiers.contains(userRole.getRole().getInstitutionId()));
    }

    private String toScimString() {
        return String.format("%s %s <%s>", this.givenName, this.familyName, this.email);
    }

    @Generated
    public User() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    @Generated
    public String getSub() {
        return this.sub;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getLastActivity() {
        return this.lastActivity;
    }

    @Generated
    public Set<Aup> getAups() {
        return this.aups;
    }

    @Generated
    public Set<UserRole> getUserRoles() {
        return this.userRoles;
    }

    @Generated
    public Set<InstitutionMembership> getInstitutionMemberships() {
        return this.institutionMemberships;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEduPersonPrincipalName(String eduPersonPrincipalName) {
        this.eduPersonPrincipalName = eduPersonPrincipalName;
    }

    @Generated
    public void setSub(String sub) {
        this.sub = sub;
    }

    @Generated
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastActivity(Instant lastActivity) {
        this.lastActivity = lastActivity;
    }

    @Generated
    public void setAups(Set<Aup> aups) {
        this.aups = aups;
    }

    @Generated
    public void setUserRoles(Set<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    @Generated
    public void setInstitutionMemberships(Set<InstitutionMembership> institutionMemberships) {
        this.institutionMemberships = institutionMemberships;
    }
}

