/*
 * Decompiled with CFR 0.152.
 */
package guests.eva;

import guests.domain.Application;
import guests.domain.UserRole;
import guests.eva.EVAService;
import guests.eva.GuestAccount;
import guests.repository.UserRoleRepository;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EVAServiceDefault
implements EVAService {
    private static final Log LOG = LogFactory.getLog(EVAServiceDefault.class);
    private final ParameterizedTypeReference<Map<String, Object>> mapParameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private final RestTemplate restTemplate = new RestTemplate();
    private final UserRoleRepository userRoleRepository;
    private final String eduRoamHost;

    @Autowired
    public EVAServiceDefault(UserRoleRepository userRoleRepository, @Value(value="${eduroam.host}") String eduRoamHost) {
        this.userRoleRepository = userRoleRepository;
        this.eduRoamHost = eduRoamHost;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(1L, TimeUnit.MINUTES);
        builder.retryOnConnectionFailure(true);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(builder.build()));
    }

    public void newMembership(UserRole userRole) {
        Application application = userRole.getRole().getApplication();
        if (application.evaProvisioningEnabled()) {
            MultiValueMap map = new GuestAccount(userRole).getRequest();
            String url = this.eduRoamHost + "/api/v1/guest/create";
            RequestEntity requestEntity = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)URI.create(url)).headers(this.httpHeaders(application))).body((Object)map);
            LOG.info((Object)String.format("SendEVA new user %s to %s for application %s", requestEntity.getBody(), requestEntity.getUrl(), application.getName()));
            Map results = (Map)this.restTemplate.exchange(requestEntity, this.mapParameterizedTypeReference).getBody();
            userRole.setServiceProviderId(String.valueOf(results.get("id")));
        }
    }

    public void deleteMembership(UserRole userRole) {
        Application application = userRole.getRole().getApplication();
        if (application.evaProvisioningEnabled()) {
            String url = this.eduRoamHost + "/api/v1/guest/disable/" + userRole.getServiceProviderId();
            RequestEntity requestEntity = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)URI.create(url)).headers(this.httpHeaders(application))).build();
            LOG.info((Object)String.format("SendEVA disable userto %s for application %s", requestEntity.getUrl(), application.getName()));
            this.restTemplate.exchange(requestEntity, this.mapParameterizedTypeReference).getBody();
            userRole.setServiceProviderId(null);
            this.userRoleRepository.save((Object)userRole);
        }
    }

    private HttpHeaders httpHeaders(Application application) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add("X-Api-Key", application.getApiKey());
        return headers;
    }
}

