/*
 * Decompiled with CFR 0.152.
 */
package guests.eva;

import guests.domain.User;
import guests.domain.UserRole;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class GuestAccount {
    private static final String EVA_DATE_PATTERN = "yyyy-MM-dd";
    private final MultiValueMap<String, String> request;

    public GuestAccount(UserRole userRole) {
        Instant endDate = userRole.getEndDate();
        Instant dateTill = endDate != null ? endDate : Instant.now().plus(30L, ChronoUnit.DAYS);
        String language = LocaleContextHolder.getLocale().getLanguage();
        this.request = new LinkedMultiValueMap();
        User user = userRole.getUser();
        this.request.add((Object)"name", (Object)user.getName());
        this.request.add((Object)"email", (Object)user.getEmail());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EVA_DATE_PATTERN);
        this.request.add((Object)"dateFrom", (Object)simpleDateFormat.format(Date.from(Instant.now())));
        this.request.add((Object)"dateTill", (Object)simpleDateFormat.format(Date.from(dateTill)));
        this.request.add((Object)"notifyByEmail", (Object)Boolean.TRUE.toString());
        this.request.add((Object)"notifyBySms", (Object)Boolean.FALSE.toString());
        this.request.add((Object)"preferredLanguage", (Object)language);
    }

    public MultiValueMap<String, String> getRequest() {
        return this.request;
    }
}

