/*
 * Decompiled with CFR 0.152.
 */
package guests.mail;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import guests.cron.IdPMetaDataResolver;
import guests.domain.Invitation;
import guests.domain.SCIMFailure;
import guests.domain.User;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailBox {
    private final JavaMailSender mailSender;
    private final String baseUrl;
    private final String emailFrom;
    private final String scimFailureEmail;
    private final String environment;
    private final IdPMetaDataResolver metaDataResolver;
    private static final Log LOG = LogFactory.getLog(MailBox.class);
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory("templates");

    public MailBox(JavaMailSender mailSender, IdPMetaDataResolver metaDataResolver, String emailFrom, String baseUrl, String scimFailureEmail, String environment) {
        this.mailSender = mailSender;
        this.emailFrom = emailFrom;
        this.baseUrl = baseUrl;
        this.scimFailureEmail = scimFailureEmail;
        this.environment = environment;
        this.metaDataResolver = metaDataResolver;
    }

    public void sendInviteMail(User user, Invitation invitation) {
        String role = invitation.getIntendedAuthority().friendlyName();
        String lang = this.preferredLanguage().toLowerCase(Locale.ROOT);
        String title = String.format("en".equals("en") ? "Invitation for %s at eduID inviters" : "Uitnodiging voor %s bij eduID uitnodigingen", role);
        String entityId = invitation.getInstitution().getEntityId();
        Optional logoOptional = this.metaDataResolver.getLogo(entityId);
        HashMap<String, String> variables = new HashMap<String, String>();
        logoOptional.ifPresent(logo -> variables.put("logo", (String)logo));
        variables.put("title", title);
        variables.put("role", role);
        variables.put("invitation", (String)invitation);
        variables.put("user", (String)user);
        variables.put("url", String.format("%s/invitations?h=%s", this.baseUrl, invitation.getHash()));
        this.sendMail(String.format("invitation_%s", lang), title, variables, new String[]{invitation.getEmail()});
    }

    private String preferredLanguage() {
        return LocaleContextHolder.getLocale().getLanguage();
    }

    public void sendProvisioningMail(String title, String userRequest, String email) {
        LOG.info((Object)String.format("Send email SCIM request %s %s to %s", title, userRequest, email));
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("userRequest", userRequest);
        this.sendMail("scim_provisioning_en", title, variables, new String[]{email});
    }

    public void sendScimFailureMail(SCIMFailure scimFailure) {
        HashMap<String, SCIMFailure> variables = new HashMap<String, SCIMFailure>();
        variables.put("scimFailure", scimFailure);
        this.sendMail("scim_failure_en", String.format("SCIM failure in environment %s", this.environment), variables, new String[]{this.scimFailureEmail});
    }

    private void sendMail(String templateName, String subject, Map<String, Object> variables, String ... to) {
        String htmlText = this.mailTemplate(templateName + ".html", variables);
        String plainText = this.mailTemplate(templateName + ".txt", variables);
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setSubject(subject);
        this.setText(plainText, htmlText, helper);
        helper.setTo(to);
        helper.setFrom(this.emailFrom);
        this.doSendMail(message);
    }

    protected void setText(String plainText, String htmlText, MimeMessageHelper helper) throws MessagingException {
        helper.setText(plainText, htmlText);
    }

    protected void doSendMail(MimeMessage message) {
        new Thread(() -> this.mailSender.send(message)).start();
    }

    private String mailTemplate(String templateName, Map<String, Object> context) {
        return this.mustacheFactory.compile(templateName).execute((Writer)new StringWriter(), context).toString();
    }
}

