/*
 * Decompiled with CFR 0.152.
 */
package guests.voot;

import guests.domain.Role;
import guests.domain.User;
import guests.domain.UserRole;
import guests.repository.UserRepository;
import guests.scim.GroupURN;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voot"}, produces={"application/json"})
@Transactional
public class VootController {
    private final UserRepository userRepository;
    private final String groupUrnPrefix;

    public VootController(UserRepository userRepository, @Value(value="${voot.group_urn_domain}") String groupUrnDomain) {
        this.userRepository = userRepository;
        this.groupUrnPrefix = String.format("urn:collab:group:%s", groupUrnDomain);
    }

    @GetMapping(value={"/{unspecified_id}"})
    public ResponseEntity<List<Map<String, String>>> getGroupMemberships(@PathVariable(value="unspecified_id") String unspecifiedId) {
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(unspecifiedId);
        if (optionalUser.isPresent()) {
            User user = (User)optionalUser.get();
            user.setLastActivity(Instant.now());
            this.userRepository.save((Object)user);
            List roles = user.getUserRoles().stream().map(arg_0 -> this.parseUserRole(arg_0)).collect(Collectors.toList());
            return ResponseEntity.ok(roles);
        }
        return ResponseEntity.ok(Collections.emptyList());
    }

    private Map<String, String> parseUserRole(UserRole userRole) {
        HashMap<String, String> res = new HashMap<String, String>();
        Role role = userRole.getRole();
        res.put("urn", GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)userRole.getRole()));
        res.put("name", role.getName());
        return res;
    }
}

