/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import guests.api.Shared;
import guests.api.UserPermissions;
import guests.domain.Aup;
import guests.domain.Institution;
import guests.domain.User;
import guests.exception.NotFoundException;
import guests.repository.InstitutionRepository;
import guests.repository.UserRepository;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/aups"}, produces={"application/json"})
@Transactional
public class AupController {
    private static final Log LOG = LogFactory.getLog(AupController.class);
    private final UserRepository userRepository;
    private final InstitutionRepository institutionRepository;

    @Autowired
    public AupController(UserRepository userRepository, InstitutionRepository institutionRepository) {
        this.userRepository = userRepository;
        this.institutionRepository = institutionRepository;
    }

    @PutMapping
    public ResponseEntity<Map<String, Integer>> aups(User authenticatedUser, @RequestBody List<Long> institutionIdentifiers) {
        User user = (User)this.userRepository.findById((Object)authenticatedUser.getId()).orElseThrow(NotFoundException::new);
        institutionIdentifiers.forEach(institutionIdentifier -> {
            UserPermissions.verifyUser((User)user, (Long)institutionIdentifier);
            Institution institution = (Institution)this.institutionRepository.findById(institutionIdentifier).orElseThrow(NotFoundException::new);
            if (!user.hasAgreedWithAup(institution)) {
                LOG.info((Object)String.format("Adding AUP for institution %s by user %s", institution.getHomeInstitution(), authenticatedUser.getName()));
                user.addAup(new Aup(institution));
            }
        });
        this.userRepository.save((Object)user);
        return Shared.createdResponse();
    }
}

