/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import guests.api.Shared;
import guests.api.UserPermissions;
import guests.config.HashGenerator;
import guests.domain.Application;
import guests.domain.Aup;
import guests.domain.Authority;
import guests.domain.Institution;
import guests.domain.InstitutionMembership;
import guests.domain.Invitation;
import guests.domain.InvitationRequest;
import guests.domain.InvitationRole;
import guests.domain.InvitationUpdate;
import guests.domain.Role;
import guests.domain.Status;
import guests.domain.User;
import guests.domain.UserRole;
import guests.eva.EVAService;
import guests.exception.InvitationEmailMatchingException;
import guests.exception.InvitationStatusException;
import guests.exception.NotFoundException;
import guests.mail.MailBox;
import guests.repository.ApplicationRepository;
import guests.repository.InstitutionRepository;
import guests.repository.InvitationRepository;
import guests.repository.RoleRepository;
import guests.repository.UserRepository;
import guests.scim.OperationType;
import guests.scim.SCIMService;
import guests.validation.EmailFormatValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invitations"}, produces={"application/json"})
@Transactional
public class InvitationController {
    private static final Log LOG = LogFactory.getLog(InvitationController.class);
    private final InvitationRepository invitationRepository;
    private final UserRepository userRepository;
    private final ApplicationRepository applicationRepository;
    private final RoleRepository roleRepository;
    private final InstitutionRepository institutionRepository;
    private final MailBox mailBox;
    private final SCIMService scimService;
    private final EVAService evaService;
    private final EmailFormatValidator emailFormatValidator = new EmailFormatValidator();

    @Autowired
    public InvitationController(InvitationRepository invitationRepository, UserRepository userRepository, ApplicationRepository applicationRepository, RoleRepository roleRepository, InstitutionRepository institutionRepository, MailBox mailBox, SCIMService scimService, EVAService evaService) {
        this.invitationRepository = invitationRepository;
        this.userRepository = userRepository;
        this.applicationRepository = applicationRepository;
        this.institutionRepository = institutionRepository;
        this.roleRepository = roleRepository;
        this.mailBox = mailBox;
        this.scimService = scimService;
        this.evaService = evaService;
    }

    @GetMapping(value={"/{hash}"})
    public ResponseEntity<Invitation> invitationByHash(BearerTokenAuthentication authentication, @PathVariable(value="hash") String hash) {
        Optional byHash = this.invitationRepository.findByHash(hash);
        if (byHash.isPresent() && !((Invitation)byHash.get()).getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException(((Invitation)byHash.get()).getInviter().getEmail());
        }
        Invitation invitation = (Invitation)byHash.orElseThrow(NotFoundException::new);
        Object details = authentication.getDetails();
        String email = details instanceof User ? ((User)details).getEmail() : (String)authentication.getTokenAttributes().get("email");
        invitation.setEmailEqualityConflict(invitation.isEnforceEmailEquality() && !invitation.getEmail().equalsIgnoreCase(email));
        return ResponseEntity.ok((Object)invitation);
    }

    @GetMapping(value={"/id/{id}"})
    public ResponseEntity<Invitation> invitationById(User authenticatedUser, @PathVariable(value="id") Long id) {
        Invitation invitation = (Invitation)this.invitationRepository.findByIdAndStatus(id, Status.OPEN).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)invitation.getInstitution().getId(), (Authority)Authority.INVITER);
        return ResponseEntity.ok((Object)invitation);
    }

    @GetMapping(value={"/institution/{institutionId}"})
    public ResponseEntity<List<Invitation>> getByInstitution(@PathVariable(value="institutionId") Long institutionId, User authenticatedUser) {
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institutionId, (Authority)Authority.INVITER);
        List invitations = this.invitationRepository.findByStatusAndInstitution_id(Status.OPEN, institutionId);
        if (authenticatedUser.isSuperAdmin()) {
            return ResponseEntity.ok((Object)invitations);
        }
        Authority authority = (Authority)authenticatedUser.authorityByInstitution(institutionId).get();
        List<Invitation> filteredInvitations = invitations.stream().filter(invitation -> authority.hasHigherRights(invitation.getIntendedAuthority())).toList();
        return ResponseEntity.ok(filteredInvitations);
    }

    @GetMapping(value={"/application/{applicationId}"})
    public ResponseEntity<List<Invitation>> getByApplication(@PathVariable(value="applicationId") Long applicationId, User authenticatedUser) {
        Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)application.getInstitution().getId(), (Authority)Authority.INVITER);
        return ResponseEntity.ok((Object)this.invitationRepository.findByStatusAndRoles_role_application_id(Status.OPEN, applicationId));
    }

    @PostMapping
    public ResponseEntity<User> accept(BearerTokenAuthentication authentication, @RequestBody Invitation invitation) throws JsonProcessingException {
        User user;
        Optional byHash = this.invitationRepository.findByHash(invitation.getHash());
        if (byHash.isPresent() && !((Invitation)byHash.get()).getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException(((Invitation)byHash.get()).getInviter().getEmail());
        }
        Invitation invitationFromDB = (Invitation)byHash.orElseThrow(NotFoundException::new);
        Object details = authentication.getDetails();
        Institution institution = invitationFromDB.getInstitution();
        if (details instanceof User) {
            User detailsFromUser = (User)details;
            user = (User)this.userRepository.findById((Object)detailsFromUser.getId()).orElseThrow(NotFoundException::new);
            Optional<InstitutionMembership> membershipOptional = user.getInstitutionMemberships().stream().filter(ms -> ms.getInstitution().getId().equals(institution.getId())).findFirst();
            if (membershipOptional.isEmpty()) {
                user.addMembership(new InstitutionMembership(invitationFromDB.getIntendedAuthority(), institution));
            }
        } else {
            user = new User(institution, invitationFromDB.getIntendedAuthority(), authentication.getTokenAttributes());
            Optional userBySub = this.userRepository.findBySubIgnoreCase(user.getSub());
            if (userBySub.isPresent()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.PRECONDITION_FAILED).build();
            }
            LOG.info((Object)String.format("Provisioning new user %s after accept invitation for institution %s", user.getName(), institution.getHomeInstitution()));
        }
        this.checkEmailEquality(user, invitationFromDB);
        if (!user.hasAgreedWithAup(institution)) {
            user.addAup(new Aup(institution));
        }
        ArrayList newUserRoles = new ArrayList();
        invitationFromDB.getRoles().forEach(invitationRole -> {
            Role role = invitationRole.getRole();
            if (user.getUserRoles().stream().noneMatch(userRole -> userRole.getRole().getId().equals(role.getId()))) {
                UserRole userRole2 = new UserRole(role, invitationFromDB.getInviter().getEmail(), invitationRole.getEndDate());
                user.addUserRole(userRole2);
                newUserRoles.add(userRole2);
            }
        });
        if (user.getId() == null || user.getUserRoles().stream().anyMatch(userRole -> !StringUtils.hasText((String)userRole.getServiceProviderId()))) {
            this.scimService.newUserRequest(user);
        }
        newUserRoles.forEach(userRole -> this.evaService.newMembership(userRole));
        User newUser = (User)this.userRepository.save((Object)user);
        newUserRoles.forEach(userRole -> this.scimService.updateRoleRequest(userRole, OperationType.Add));
        invitationFromDB.setStatus(Status.ACCEPTED);
        this.invitationRepository.save((Object)invitationFromDB);
        LOG.info((Object)String.format("Accepting invitation %s for user %s with roles %s", invitationFromDB.getInstitution().getHomeInstitution(), user.getName(), invitationFromDB.getRoles()));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)newUser);
    }

    @PutMapping
    public ResponseEntity<Map<String, Integer>> invite(User authenticatedUser, @RequestBody InvitationRequest invitationRequest) {
        Invitation invitationData = invitationRequest.getInvitation();
        Institution institution = (Institution)this.institutionRepository.findById((Object)invitationRequest.getInstitutionId()).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institution.getId(), (Authority)Authority.INVITER);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institution.getId(), (Authority)invitationData.getIntendedAuthority());
        UserPermissions.verifyRoles((User)authenticatedUser, (Invitation)invitationData, (Institution)institution);
        List invites = invitationRequest.getInvites();
        Set emails = this.emailFormatValidator.validateEmails(invites);
        emails.forEach(email -> {
            Invitation invitation = new Invitation(invitationData.getIntendedAuthority(), Status.OPEN, HashGenerator.generateHash(), authenticatedUser, institution, email);
            invitation.setMessage(invitationData.getMessage());
            invitation.setInstitution(invitationData.getInstitution());
            invitation.defaults();
            invitation.setEnforceEmailEquality(invitationData.isEnforceEmailEquality());
            invitation.setExpiryDate(invitationData.getExpiryDate());
            invitation.setInstitution(institution);
            invitationData.getRoles().forEach(invitationRole -> invitation.addInvitationRole(new InvitationRole(invitationRole.getRole(), invitationRole.getEndDate())));
            Invitation saved = (Invitation)this.invitationRepository.save((Object)invitation);
            saved.getRoles().forEach(invitationRole -> {
                Role transientRole = invitationRole.getRole();
                Role persistentRole = (Role)this.roleRepository.findById((Object)transientRole.getId()).orElseThrow(NotFoundException::new);
                transientRole.setApplication(persistentRole.getApplication());
                transientRole.setName(persistentRole.getName());
            });
            this.mailBox.sendInviteMail(authenticatedUser, saved);
            LOG.info((Object)String.format("Sending invite to %s for roles %s in institution %s by %s", email, saved.getRoles().stream().map(r -> r.getRole().getName()).collect(Collectors.toList()), invitation.getInstitution().getHomeInstitution(), authenticatedUser.getName()));
        });
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(Collections.singletonMap("status", 201));
    }

    @PutMapping(value={"/resend"})
    public ResponseEntity<Map<String, Integer>> resend(User authenticatedUser, @RequestBody InvitationUpdate invitation) {
        Invitation invitationFromDB = this.getInvitationFromDB(authenticatedUser, invitation.getId());
        invitationFromDB.setMessage(invitation.getMessage());
        invitationFromDB.setExpiryDate(invitation.getExpiryDate());
        this.invitationRepository.save((Object)invitationFromDB);
        this.mailBox.sendInviteMail(authenticatedUser, invitationFromDB);
        LOG.info((Object)String.format("Resending invite to %s for roles %s in institution %s", authenticatedUser.getName(), invitationFromDB.getRoles().stream().map(r -> r.getRole().getName()).collect(Collectors.toList()), invitationFromDB.getInstitution().getHomeInstitution()));
        return Shared.createdResponse();
    }

    @PutMapping(value={"/update-expiry-date"})
    public ResponseEntity<Map<String, Integer>> update(User authenticatedUser, @RequestBody InvitationUpdate invitation) {
        Invitation invitationFromDB = this.getInvitationFromDB(authenticatedUser, invitation.getId());
        invitationFromDB.setExpiryDate(invitation.getExpiryDate());
        this.invitationRepository.save((Object)invitationFromDB);
        return Shared.createdResponse();
    }

    @DeleteMapping(value={"{id}"})
    public ResponseEntity<Map<String, Integer>> deleteInvitation(User authenticatedUser, @PathVariable(value="id") Long id) {
        Invitation invitation = this.getInvitationFromDB(authenticatedUser, id);
        this.invitationRepository.delete((Object)invitation);
        LOG.info((Object)String.format("Deleting invite to %s for roles %s in institution %s", authenticatedUser.getName(), invitation.getRoles().stream().map(r -> r.getRole().getName()).collect(Collectors.toList()), invitation.getInstitution().getHomeInstitution()));
        return Shared.createdResponse();
    }

    private Invitation getInvitationFromDB(User authenticatedUser, Long id) {
        Invitation invitationFromDB = (Invitation)this.invitationRepository.findByIdAndStatus(id, Status.OPEN).orElseThrow(NotFoundException::new);
        Long institutionId = invitationFromDB.getInstitution().getId();
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institutionId, (Authority)Authority.INVITER);
        this.verifyInviterAuthority(authenticatedUser, invitationFromDB, institutionId);
        return invitationFromDB;
    }

    private void verifyInviterAuthority(User authenticatedUser, Invitation invitation, Long institutionId) {
        Authority authority;
        if (!authenticatedUser.isSuperAdmin() && (authority = (Authority)authenticatedUser.authorityByInstitution(institutionId).orElseThrow(NotFoundException::new)).equals((Object)Authority.INVITER) && !invitation.getIntendedAuthority().equals((Object)Authority.GUEST)) {
            throw UserPermissions.userRestrictedException((User)authenticatedUser, (Long)institutionId);
        }
    }

    private void checkEmailEquality(User user, Invitation invitation) {
        if (invitation.isEnforceEmailEquality() && !invitation.getEmail().equalsIgnoreCase(user.getEmail())) {
            throw new InvitationEmailMatchingException(String.format("Invitation email %s does not match user email %s", invitation.getEmail(), user.getEmail()));
        }
    }
}

