/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import guests.api.Shared;
import guests.api.UserPermissions;
import guests.domain.Application;
import guests.domain.Authority;
import guests.domain.ObjectExists;
import guests.domain.Role;
import guests.domain.RoleExists;
import guests.domain.User;
import guests.exception.NotFoundException;
import guests.repository.ApplicationRepository;
import guests.repository.RoleRepository;
import guests.scim.SCIMService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/roles"}, produces={"application/json"})
@Transactional
public class RoleController {
    private static final Log LOG = LogFactory.getLog(RoleController.class);
    private final RoleRepository roleRepository;
    private final ApplicationRepository applicationRepository;
    private final SCIMService scimService;

    @Autowired
    public RoleController(RoleRepository roleRepository, ApplicationRepository applicationRepository, SCIMService scimService) {
        this.roleRepository = roleRepository;
        this.applicationRepository = applicationRepository;
        this.scimService = scimService;
    }

    @GetMapping(value={"/institution/{institutionId}"})
    public ResponseEntity<List<Role>> rolesByInstitution(@PathVariable(value="institutionId") Long institutionId, User user) {
        UserPermissions.verifyUser((User)user, (Long)institutionId);
        List roles = this.roleRepository.findByApplication_institution_id(institutionId);
        return ResponseEntity.ok((Object)roles);
    }

    @GetMapping(value={"/application/{applicationId}"})
    public ResponseEntity<List<Role>> rolesByApplication(@PathVariable(value="applicationId") Long applicationId, User user) {
        Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(NotFoundException::new);
        UserPermissions.verifyUser((User)user, (Long)application.getInstitution().getId());
        List roles = this.roleRepository.findByApplication_id(applicationId);
        return ResponseEntity.ok((Object)roles);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Role> getById(User user, @PathVariable(value="id") Long id) {
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)user, (Long)role.getApplication().getInstitution().getId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        return ResponseEntity.ok((Object)role);
    }

    @RequestMapping(method={RequestMethod.POST, RequestMethod.PUT})
    public ResponseEntity<Role> save(User user, @RequestBody Role role) {
        this.restrictUser(user, role);
        boolean isTransientRole = role.getId() == null;
        role = (Role)this.roleRepository.save((Object)role);
        if (isTransientRole) {
            role.setApplication((Application)this.applicationRepository.findById((Object)role.getApplication().getId()).get());
            this.scimService.newRoleRequest(role);
        }
        LOG.info((Object)String.format("Creating role %s for application %s by user %s", role.getName(), role.getApplication().getName(), user.getName()));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)role);
    }

    @PostMapping(value={"name-exists"})
    public ResponseEntity<Map<String, Boolean>> namExists(User authenticatedUser, @RequestBody RoleExists roleExists) {
        Application application = (Application)this.applicationRepository.findById((Object)roleExists.getApplicationId()).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)application.getInstitution().getId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        Optional optional = this.roleRepository.findByApplication_idAndNameIgnoreCase(roleExists.getApplicationId(), roleExists.getUniqueAttribute());
        return Shared.doesExists((ObjectExists)roleExists, (Optional)optional);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Integer>> delete(User authenticatedUser, @PathVariable(value="id") Long id) {
        Role role = (Role)this.roleRepository.findById((Object)id).get();
        this.restrictUser(authenticatedUser, role);
        this.roleRepository.delete((Object)role);
        this.scimService.deleteRolesRequest(role);
        LOG.info((Object)String.format("Deleting role %s for application %s by user %s", role.getName(), role.getApplication().getName(), authenticatedUser.getName()));
        return Shared.createdResponse();
    }

    private void restrictUser(User user, Role role) throws AuthenticationException {
        Application application = (Application)this.applicationRepository.findById((Object)role.getApplication().getId()).orElseThrow(NotFoundException::new);
        UserPermissions.verifyAuthority((User)user, (Long)application.getInstitution().getId(), (Authority)Authority.INSTITUTION_ADMINISTRATOR);
    }
}

