/*
 * Decompiled with CFR 0.152.
 */
package guests.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import guests.api.Shared;
import guests.api.UserPermissions;
import guests.domain.Authority;
import guests.domain.Role;
import guests.domain.SCIMFailure;
import guests.domain.User;
import guests.exception.NotFoundException;
import guests.repository.RoleRepository;
import guests.repository.SCIMFailureRepository;
import guests.repository.UserRepository;
import guests.scim.SCIMService;
import guests.scim.ThreadLocalSCIMFailureStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/scim"}, produces={"application/json"})
@Transactional
public class SCIMFailureController {
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final SCIMFailureRepository scimFailureRepository;
    private final SCIMService scimService;

    @Autowired
    public SCIMFailureController(UserRepository userRepository, RoleRepository roleRepository, SCIMFailureRepository scimFailureRepository, SCIMService scimService) {
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.scimFailureRepository = scimFailureRepository;
        this.scimService = scimService;
    }

    @GetMapping(value={"/institution/{institutionId}"})
    public ResponseEntity<List<SCIMFailure>> failures(User authenticatedUser, @PathVariable(value="institutionId") Long institutionId) {
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institutionId, (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        List scimFailures = this.scimFailureRepository.findByApplication_institution_id(institutionId);
        return ResponseEntity.ok((Object)scimFailures);
    }

    @GetMapping(value={"/institution/{institutionId}/count"})
    public ResponseEntity<Map<String, Long>> failuresCounts(User authenticatedUser, @PathVariable(value="institutionId") Long institutionId) {
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institutionId, (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        long count = this.scimFailureRepository.countByApplication_institution_id(institutionId);
        return ResponseEntity.ok(Collections.singletonMap("count", count));
    }

    @GetMapping(value={"/id/{id}/{institutionId}"})
    public ResponseEntity<SCIMFailure> failureById(User authenticatedUser, @PathVariable(value="id") Long id, @PathVariable(value="institutionId") Long institutionId) {
        SCIMFailure scimFailure = this.getScimFailure(authenticatedUser, id, institutionId);
        return ResponseEntity.ok((Object)scimFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/id/{id}/{institutionId}"})
    public ResponseEntity<Map<String, Integer>> resend(User authenticatedUser, @PathVariable(value="id") Long id, @PathVariable(value="institutionId") Long institutionId) throws JsonProcessingException {
        UserPermissions.verifySuperUser((User)authenticatedUser);
        try {
            ThreadLocalSCIMFailureStrategy.startIgnoringFailures();
            SCIMFailure scimFailure = this.getScimFailure(authenticatedUser, id, institutionId);
            Optional serializableOptional = this.scimService.resendScimFailure(scimFailure);
            serializableOptional.ifPresent(serializable -> {
                if (serializable instanceof User) {
                    User user = (User)serializable;
                    this.userRepository.save((Object)user);
                } else if (serializable instanceof Role) {
                    Role role = (Role)serializable;
                    this.roleRepository.save((Object)role);
                }
            });
            this.scimFailureRepository.delete((Object)scimFailure);
            ResponseEntity responseEntity = Shared.createdResponse();
            return responseEntity;
        }
        finally {
            ThreadLocalSCIMFailureStrategy.stopIgnoringFailures();
        }
    }

    @DeleteMapping(value={"/id/{id}/{institutionId}"})
    public ResponseEntity<Map<String, Integer>> delete(User authenticatedUser, @PathVariable(value="id") Long id, @PathVariable(value="institutionId") Long institutionId) {
        SCIMFailure scimFailure = this.getScimFailure(authenticatedUser, id, institutionId);
        this.scimFailureRepository.delete((Object)scimFailure);
        return Shared.createdResponse();
    }

    private SCIMFailure getScimFailure(User authenticatedUser, @PathVariable(value="id") Long id, @PathVariable(value="institutionId") Long institutionId) {
        UserPermissions.verifyAuthority((User)authenticatedUser, (Long)institutionId, (Authority)Authority.INSTITUTION_ADMINISTRATOR);
        SCIMFailure scimFailure = (SCIMFailure)this.scimFailureRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        if (!authenticatedUser.isSuperAdmin() && !scimFailure.getApplication().getInstitution().getId().equals(institutionId)) {
            throw UserPermissions.userRestrictedException((User)authenticatedUser, (Long)institutionId);
        }
        return scimFailure;
    }
}

