/*
 * Decompiled with CFR 0.152.
 */
package guests.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import guests.domain.Auditable;
import guests.domain.InstitutionMembership;
import guests.domain.NameHolder;
import guests.domain.NameHolderListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.util.StringUtils;

@Entity(name="institutions")
@EntityListeners(value={NameHolderListener.class})
public class Institution
implements Serializable,
NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="entity_id")
    @NotNull
    private String entityId;
    @Column(name="home_institution")
    @NotNull
    private String homeInstitution;
    @Column(name="display_name")
    private String displayName;
    @Column(name="aup_url")
    private String aupUrl;
    @Column(name="aup_version")
    private Integer aupVersion;
    @Embedded
    private Auditable auditable = new Auditable();
    @OneToMany(mappedBy="institution", orphanRemoval=true, fetch=FetchType.LAZY)
    @JsonIgnore
    private Set<InstitutionMembership> institutionMemberships = new HashSet();

    public Institution(String displayName, String entityId, String homeInstitution, String aupUrl, Integer aupVersion) {
        this.displayName = displayName;
        this.entityId = entityId;
        this.homeInstitution = homeInstitution;
        this.aupUrl = aupUrl;
        this.aupVersion = aupVersion;
    }

    public Institution(Institution institution) {
        this.entityId = institution.getEntityId();
        this.homeInstitution = institution.getHomeInstitution();
        this.displayName = institution.getDisplayName();
    }

    @JsonIgnore
    public void nameUrnCompatibilityCheck() {
        this.homeInstitution = this.compatibleUrnName(this.homeInstitution);
    }

    @JsonIgnore
    public void invariantAupVersion() {
        this.aupVersion = StringUtils.hasText((String)this.aupUrl) ? Integer.valueOf(this.aupVersion == null ? 1 : this.aupVersion) : null;
    }

    @JsonIgnore
    public void incrementAup() {
        if (StringUtils.hasText((String)this.aupUrl)) {
            this.aupVersion = this.aupVersion == null ? 1 : this.aupVersion + 1;
        }
    }

    @Generated
    public Institution() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getHomeInstitution() {
        return this.homeInstitution;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getAupUrl() {
        return this.aupUrl;
    }

    @Generated
    public Integer getAupVersion() {
        return this.aupVersion;
    }

    @Generated
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Generated
    public Set<InstitutionMembership> getInstitutionMemberships() {
        return this.institutionMemberships;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setHomeInstitution(String homeInstitution) {
        this.homeInstitution = homeInstitution;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setAupUrl(String aupUrl) {
        this.aupUrl = aupUrl;
    }

    @Generated
    public void setAupVersion(Integer aupVersion) {
        this.aupVersion = aupVersion;
    }

    @Generated
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    @JsonIgnore
    @Generated
    public void setInstitutionMemberships(Set<InstitutionMembership> institutionMemberships) {
        this.institutionMemberships = institutionMemberships;
    }
}

