/*
 * Decompiled with CFR 0.152.
 */
package guests.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import guests.domain.Application;
import guests.domain.Auditable;
import guests.domain.Authority;
import guests.domain.Institution;
import guests.domain.NameHolder;
import guests.domain.NameHolderListener;
import guests.domain.ServiceProviderIdentifier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.LazyInitializationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.StringUtils;

@Entity(name="roles")
@EntityListeners(value={NameHolderListener.class})
public class Role
implements Serializable,
NameHolder,
ServiceProviderIdentifier {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String name;
    @Column(name="display_name")
    private String displayName;
    @Column(name="service_provider_id")
    private String serviceProviderId;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private Authority authority = Authority.INVITER;
    @Column(name="instant_available")
    private boolean instantAvailable;
    @Column(name="default_expiry_days")
    private Integer defaultExpiryDays;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Application application;
    @Embedded
    private Auditable auditable = new Auditable();

    public Role(String name, Application application) {
        this.name = name;
        this.application = application;
    }

    public Role(Long id, String roleName) {
        this.id = id;
        this.name = roleName;
    }

    @JsonProperty(value="application", access=JsonProperty.Access.READ_ONLY)
    public Map<String, Object> getApplicationMap() {
        try {
            BearerTokenAuthentication tokenAuthentication;
            Application application = this.getApplication();
            Institution institution = application.getInstitution();
            HashMap<String, Object> applicationMap = new HashMap<String, Object>();
            applicationMap.put("id", application.getId());
            applicationMap.put("name", application.getName());
            String landingPage = application.getLandingPage();
            if (StringUtils.hasText((String)landingPage) && landingPage.contains("%%eppn%%") && (tokenAuthentication = (BearerTokenAuthentication)SecurityContextHolder.getContext().getAuthentication()) != null && tokenAuthentication.getTokenAttributes().containsKey("eduperson_principal_name")) {
                String edupersonPrincipalName = (String)tokenAuthentication.getTokenAttributes().get("eduperson_principal_name");
                landingPage = landingPage.replaceFirst("%%eppn%%", edupersonPrincipalName);
            }
            applicationMap.put("landingPage", landingPage);
            HashMap<String, Long> institutionMap = new HashMap<String, Long>();
            institutionMap.put("id", institution.getId());
            applicationMap.put("institution", institutionMap);
            return applicationMap;
        }
        catch (LazyInitializationException e) {
            return null;
        }
    }

    @JsonIgnore
    public Long getInstitutionId() {
        return this.getApplication().getInstitution().getId();
    }

    @JsonIgnore
    public void nameUrnCompatibilityCheck() {
        this.name = this.compatibleUrnName(this.name);
    }

    @Generated
    public Role() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getServiceProviderId() {
        return this.serviceProviderId;
    }

    @Generated
    public Authority getAuthority() {
        return this.authority;
    }

    @Generated
    public boolean isInstantAvailable() {
        return this.instantAvailable;
    }

    @Generated
    public Integer getDefaultExpiryDays() {
        return this.defaultExpiryDays;
    }

    @Generated
    public Application getApplication() {
        return this.application;
    }

    @Generated
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setServiceProviderId(String serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    @Generated
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Generated
    public void setInstantAvailable(boolean instantAvailable) {
        this.instantAvailable = instantAvailable;
    }

    @Generated
    public void setDefaultExpiryDays(Integer defaultExpiryDays) {
        this.defaultExpiryDays = defaultExpiryDays;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setApplication(Application application) {
        this.application = application;
    }

    @Generated
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }
}

