/*
 * Decompiled with CFR 0.152.
 */
package guests.scim;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import guests.domain.Application;
import guests.domain.Institution;
import guests.domain.Role;
import guests.domain.SCIMFailure;
import guests.domain.ServiceProviderIdentifier;
import guests.domain.ServiceProviderIdentifierRef;
import guests.domain.User;
import guests.domain.UserRole;
import guests.exception.NotFoundException;
import guests.mail.MailBox;
import guests.repository.RoleRepository;
import guests.repository.SCIMFailureRepository;
import guests.repository.UserRepository;
import guests.repository.UserRoleRepository;
import guests.scim.ExternalID;
import guests.scim.GroupPatchRequest;
import guests.scim.GroupRequest;
import guests.scim.GroupURN;
import guests.scim.Member;
import guests.scim.Operation;
import guests.scim.OperationType;
import guests.scim.SCIMService;
import guests.scim.SCIMServiceDefault;
import guests.scim.ThreadLocalSCIMFailureStrategy;
import guests.scim.UserRequest;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class SCIMServiceDefault
implements SCIMService {
    public static final String USER_API = "users";
    public static final String GROUP_API = "groups";
    private static final Log LOG = LogFactory.getLog(SCIMServiceDefault.class);
    private final ParameterizedTypeReference<Map<String, Object>> mapParameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private final ParameterizedTypeReference<String> stringParameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private final RestTemplate restTemplate = new RestTemplate();
    private final SCIMFailureRepository scimFailureRepository;
    private final UserRepository userRepository;
    private final UserRoleRepository userRoleRepository;
    private final RoleRepository roleRepository;
    private final ObjectMapper objectMapper;
    private final MailBox mailBox;
    private final String groupUrnPrefix;

    @Autowired
    public SCIMServiceDefault(SCIMFailureRepository scimFailureRepository, UserRepository userRepository, UserRoleRepository userRoleRepository, RoleRepository roleRepository, ObjectMapper objectMapper, MailBox mailBox, @Value(value="${voot.group_urn_domain}") String groupUrnDomain) {
        this.scimFailureRepository = scimFailureRepository;
        this.userRepository = userRepository;
        this.userRoleRepository = userRoleRepository;
        this.roleRepository = roleRepository;
        this.objectMapper = objectMapper;
        this.mailBox = mailBox;
        this.groupUrnPrefix = String.format("urn:collab:group:%s", groupUrnDomain);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(1L, TimeUnit.MINUTES);
        builder.retryOnConnectionFailure(true);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(builder.build()));
    }

    public void newUserRequest(User user) {
        Map applicationListMap = user.userRolesPerApplicationProvisioningEnabled();
        applicationListMap.forEach((application, userRoles) -> {
            Optional userRoleProvisioned = this.getUserRoleProvisioned(userRoles);
            if (userRoleProvisioned.isPresent()) {
                UserRole userRole = (UserRole)userRoleProvisioned.get();
                userRoles.forEach(ur -> ur.setServiceProviderId(userRole.getServiceProviderId()));
            } else {
                UserRole userRole = (UserRole)userRoles.get(0);
                if (this.hasEmailHook(application)) {
                    String serviceProviderID = UUID.randomUUID().toString();
                    userRoles.forEach(ur -> ur.setServiceProviderId(serviceProviderID));
                    String mailUserRequest = this.prettyJson((Object)new UserRequest(user, (ServiceProviderIdentifier)userRole));
                    this.newRequest(application, mailUserRequest, USER_API, (ServiceProviderIdentifier)userRole);
                } else {
                    String userRequest = this.prettyJson((Object)new UserRequest(user));
                    this.newRequest(application, userRequest, USER_API, (ServiceProviderIdentifier)userRole);
                    userRoles.forEach(ur -> ur.setServiceProviderId(userRole.getServiceProviderId()));
                }
            }
        });
    }

    public void updateUserRequest(User user) {
        user.userRolesPerApplicationProvisioningEnabled().forEach((application, userRoles) -> {
            Optional userRoleProvisioned = this.getUserRoleProvisioned(userRoles);
            if (userRoleProvisioned.isPresent()) {
                UserRole userRole = (UserRole)userRoleProvisioned.get();
                String userRequest = this.prettyJson((Object)new UserRequest(user, (ServiceProviderIdentifier)userRole));
                this.updateRequest(application, userRequest, USER_API, (ServiceProviderIdentifier)userRole, HttpMethod.PUT);
            } else {
                this.newUserRequest(user);
            }
        });
    }

    public void deleteUserRequest(User user) {
        user.getUserRoles().forEach(userRole -> this.doUpdateRoleRequest(userRole, OperationType.Remove, (Collection)user.getUserRoles()));
        user.userRolesPerApplicationProvisioningEnabled().forEach((application, userRoles) -> {
            Optional userRoleProvisioned = this.getUserRoleProvisioned(userRoles);
            if (userRoleProvisioned.isPresent()) {
                UserRole userRole = (UserRole)userRoleProvisioned.get();
                String userRequest = this.prettyJson((Object)new UserRequest(user, (ServiceProviderIdentifier)userRole));
                this.deleteRequest(application, userRequest, USER_API, (ServiceProviderIdentifier)userRole);
            }
        });
    }

    public void deleteUserByInstitutionRequest(User user, Institution institution) {
        List<UserRole> userRolesToDelete = user.getUserRoles().stream().filter(role -> role.getRole().getInstitutionId().equals(institution.getId())).collect(Collectors.toList());
        userRolesToDelete.forEach(userRole -> this.doUpdateRoleRequest(userRole, OperationType.Remove, (Collection)userRolesToDelete));
        Map userRolesPerApplication = user.userRolesPerApplicationProvisioningEnabled();
        userRolesPerApplication.entrySet().removeIf(entry -> !((Application)entry.getKey()).getInstitution().getId().equals(institution.getId()));
        userRolesPerApplication.forEach((application, userRoles) -> {
            Optional userRoleProvisioned = this.getUserRoleProvisioned(userRoles);
            if (userRoleProvisioned.isPresent()) {
                UserRole userRole = (UserRole)userRoleProvisioned.get();
                String userRequest = this.prettyJson((Object)new UserRequest(user, (ServiceProviderIdentifier)userRole));
                this.deleteRequest(application, userRequest, USER_API, (ServiceProviderIdentifier)userRole);
            }
        });
    }

    public void newRoleRequest(Role role) {
        this.doNewRoleRequest(role, Collections.emptyList());
    }

    public void updateRoleRequest(UserRole userRole, OperationType operationType) {
        this.doUpdateRoleRequest(userRole, operationType, Collections.emptyList());
    }

    public void deleteRolesRequest(Role role) {
        if (role.getApplication().scimProvisioningEnabled() && StringUtils.hasText((String)role.getServiceProviderId())) {
            String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
            String groupRequest = this.prettyJson((Object)new GroupRequest(externalId, (ServiceProviderIdentifier)role, role.getName(), Collections.emptyList()));
            this.deleteRequest(role.getApplication(), groupRequest, GROUP_API, (ServiceProviderIdentifier)role);
        }
    }

    public Optional<Serializable> resendScimFailure(SCIMFailure scimFailure) throws JsonProcessingException {
        Map request = StringUtils.hasText((String)scimFailure.getMessage()) ? (Map)this.objectMapper.readValue(scimFailure.getMessage(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : Collections.emptyMap();
        HttpMethod httpMethod = HttpMethod.valueOf((String)scimFailure.getHttpMethod());
        if (USER_API.equals(scimFailure.getApi())) {
            switch (4.$SwitchMap$org$springframework$http$HttpMethod[httpMethod.ordinal()]) {
                case 1: {
                    return this.changeUserRequest(request, arg_0 -> this.newUserRequest(arg_0));
                }
                case 2: {
                    return this.changeUserRequest(request, arg_0 -> this.updateUserRequest(arg_0));
                }
                case 3: {
                    this.deleteRequest(scimFailure.getApplication(), scimFailure.getMessage(), USER_API, (ServiceProviderIdentifier)new ServiceProviderIdentifierRef(scimFailure.getServiceProviderId()));
                    return Optional.empty();
                }
            }
            throw new IllegalArgumentException(String.format("Unknown HTTPmethod %s", scimFailure.getHttpMethod()));
        }
        if (GROUP_API.equals(scimFailure.getApi())) {
            switch (4.$SwitchMap$org$springframework$http$HttpMethod[httpMethod.ordinal()]) {
                case 1: {
                    String roleUrn = (String)request.get("externalId");
                    ExternalID externalID = GroupURN.parseUrnRole((String)roleUrn);
                    Role role = (Role)this.roleRepository.findByApplication_institution_homeInstitutionIgnoreCaseAndApplication_nameIgnoreCaseAndNameIgnoreCase(externalID.institutionHome(), externalID.applicationName(), externalID.roleName()).orElseThrow(NotFoundException::new);
                    this.newRoleRequest(role);
                    return Optional.of(role);
                }
                case 2: 
                case 4: {
                    Role role = (Role)this.roleRepository.findByServiceProviderId(scimFailure.getServiceProviderId()).orElseThrow(NotFoundException::new);
                    this.updateRequest(role.getApplication(), scimFailure.getMessage(), GROUP_API, (ServiceProviderIdentifier)role, httpMethod);
                    return Optional.of(role);
                }
                case 3: {
                    this.deleteRequest(scimFailure.getApplication(), scimFailure.getMessage(), GROUP_API, (ServiceProviderIdentifier)new ServiceProviderIdentifierRef(scimFailure.getServiceProviderId()));
                    return Optional.empty();
                }
            }
            throw new IllegalArgumentException(String.format("Unknown HTTPmethod %s", scimFailure.getHttpMethod()));
        }
        throw new IllegalArgumentException(String.format("Unknown API %s", scimFailure.getApi()));
    }

    private void doNewRoleRequest(Role role, Collection<UserRole> userRolesToBeDeleted) {
        Application application = role.getApplication();
        if (application.scimProvisioningEnabled()) {
            if (this.hasEmailHook(application)) {
                role.setServiceProviderId(UUID.randomUUID().toString());
            }
            List userRoles = this.getUserRoles(role, userRolesToBeDeleted);
            String groupRequest = this.initiateGroupRequest(role, userRoles);
            this.newRequest(application, groupRequest, GROUP_API, (ServiceProviderIdentifier)role);
        }
    }

    private List<UserRole> getUserRoles(Role role, Collection<UserRole> userRolesToBeDeleted) {
        Set userRoleIdentifiers = userRolesToBeDeleted.stream().map(UserRole::getId).collect(Collectors.toSet());
        return this.userRoleRepository.findByRoleId(role.getId()).stream().filter(userRole -> !userRoleIdentifiers.contains(userRole.getId())).collect(Collectors.toList());
    }

    private void doUpdateRoleRequest(UserRole userRole, OperationType operationType, Collection<UserRole> userRolesToBeDeleted) {
        Role role = userRole.getRole();
        Application application = role.getApplication();
        if (application.scimProvisioningEnabled()) {
            if (StringUtils.hasText((String)role.getServiceProviderId())) {
                if (application.isUpdateRolePutMethod()) {
                    List userRoles = this.getUserRoles(role, userRolesToBeDeleted);
                    String groupRequest = this.initiateGroupRequest(role, userRoles);
                    this.updateRequest(application, groupRequest, GROUP_API, (ServiceProviderIdentifier)role, HttpMethod.PUT);
                } else {
                    String groupRequest = this.patchGroupRequest(role, userRole, operationType);
                    this.updateRequest(application, groupRequest, GROUP_API, (ServiceProviderIdentifier)role, HttpMethod.PATCH);
                }
            } else {
                this.doNewRoleRequest(role, userRolesToBeDeleted);
            }
        }
    }

    private String initiateGroupRequest(Role role, List<UserRole> userRoles) {
        Collection<Member> members = userRoles.stream().map(userRole -> new Member(userRole.getServiceProviderId())).filter(member -> StringUtils.hasText((String)member.getValue())).collect(Collectors.toMap(Member::getValue, member -> member, (a1, a2) -> a1)).values();
        String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        return this.prettyJson((Object)new GroupRequest(externalId, (ServiceProviderIdentifier)role, role.getName(), new ArrayList<Member>(members)));
    }

    private String patchGroupRequest(Role role, UserRole userRole, OperationType operationType) {
        String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        GroupPatchRequest request = new GroupPatchRequest(externalId, role.getServiceProviderId(), new Operation(operationType, userRole));
        return this.prettyJson((Object)request);
    }

    private Optional<UserRole> getUserRoleProvisioned(List<UserRole> userRoles) {
        return userRoles.stream().filter(userRole -> StringUtils.hasText((String)userRole.getServiceProviderId())).findFirst();
    }

    private Optional<Serializable> changeUserRequest(Map<String, Object> request, Consumer<User> userConsumer) {
        String externalId = (String)request.get("externalId");
        User user = (User)this.userRepository.findByEduPersonPrincipalNameIgnoreCase(externalId).orElseThrow(NotFoundException::new);
        userConsumer.accept(user);
        return Optional.of(user);
    }

    private void newRequest(Application application, String request, String apiType, ServiceProviderIdentifier serviceProviderIdentifier) {
        if (this.hasEmailHook(application)) {
            this.mailBox.sendProvisioningMail(String.format("SCIM %s: CREATE", apiType), request, application.getProvisioningHookEmail());
        } else {
            URI uri = this.provisioningUri(application, apiType, Optional.empty());
            RequestEntity requestEntity = new RequestEntity((Object)request, (MultiValueMap)this.httpHeaders(application), HttpMethod.POST, uri);
            Optional results = this.doExchange(requestEntity, apiType, serviceProviderIdentifier, this.mapParameterizedTypeReference, application);
            results.ifPresent(map -> {
                String id = map.get("id").toString();
                serviceProviderIdentifier.setServiceProviderId(id);
            });
        }
    }

    private void updateRequest(Application application, String request, String apiType, ServiceProviderIdentifier serviceProviderIdentifier, HttpMethod httpMethod) {
        if (this.hasEmailHook(application)) {
            this.mailBox.sendProvisioningMail(String.format("SCIM %s: UPDATE", apiType), request, application.getProvisioningHookEmail());
        } else {
            URI uri = this.provisioningUri(application, apiType, Optional.of(serviceProviderIdentifier));
            RequestEntity requestEntity = new RequestEntity((Object)request, (MultiValueMap)this.httpHeaders(application), httpMethod, uri);
            this.doExchange(requestEntity, apiType, serviceProviderIdentifier, this.mapParameterizedTypeReference, application);
        }
    }

    private void deleteRequest(Application application, String request, String apiType, ServiceProviderIdentifier serviceProviderIdentifier) {
        if (this.hasEmailHook(application)) {
            this.mailBox.sendProvisioningMail(String.format("SCIM %s: DELETE", apiType), request, application.getProvisioningHookEmail());
        } else {
            URI uri = this.provisioningUri(application, apiType, Optional.of(serviceProviderIdentifier));
            HttpHeaders headers = new HttpHeaders();
            headers.setBasicAuth(application.getProvisioningHookUsername(), application.getProvisioningHookPassword());
            RequestEntity requestEntity = new RequestEntity((Object)request, (MultiValueMap)headers, HttpMethod.DELETE, uri);
            this.doExchange(requestEntity, apiType, serviceProviderIdentifier, this.stringParameterizedTypeReference, application);
        }
    }

    private <T, S> Optional<T> doExchange(RequestEntity<S> requestEntity, String api, ServiceProviderIdentifier serviceProviderIdentifier, ParameterizedTypeReference<T> typeReference, Application application) {
        try {
            LOG.info((Object)String.format("Send %s SCIM request with %s httpMethod %s and body %s to %s", api, requestEntity.getUrl(), requestEntity.getMethod(), requestEntity.getBody(), application.getName()));
            return Optional.ofNullable(this.restTemplate.exchange(requestEntity, typeReference).getBody());
        }
        catch (RestClientException e) {
            LOG.error((Object)"Exception in SCIM exchange", (Throwable)e);
            if (ThreadLocalSCIMFailureStrategy.ignoreFailures().booleanValue()) {
                throw e;
            }
            Object body = requestEntity.getBody();
            SCIMFailure scimFailure = new SCIMFailure((String)body, api, requestEntity.getMethod().toString(), requestEntity.getUrl().toString(), serviceProviderIdentifier.getServiceProviderId(), application);
            this.scimFailureRepository.save((Object)scimFailure);
            this.mailBox.sendScimFailureMail(scimFailure);
            return Optional.empty();
        }
    }

    private boolean hasEmailHook(Application application) {
        return StringUtils.hasText((String)application.getProvisioningHookEmail());
    }

    private URI provisioningUri(Application application, String objectType, Optional<ServiceProviderIdentifier> spIdentifier) {
        String postFix = spIdentifier.map(role -> "/" + role.getServiceProviderId()).orElse("");
        return URI.create(String.format("%s/%s%s", application.getProvisioningHookUrl(), objectType, postFix));
    }

    private String prettyJson(Object obj) {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    private HttpHeaders httpHeaders(Application application) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(application.getProvisioningHookUsername(), application.getProvisioningHookPassword());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }
}

