/*
 * Decompiled with CFR 0.152.
 */
package guests.security;

import guests.config.SuperAdmin;
import guests.domain.Authority;
import guests.domain.Institution;
import guests.domain.User;
import guests.repository.InstitutionRepository;
import guests.repository.UserRepository;
import guests.scim.SCIMService;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.web.filter.GenericFilterBean;

public class UserAuthenticationFilter
extends GenericFilterBean {
    private static final Log LOG = LogFactory.getLog(UserAuthenticationFilter.class);
    private final InstitutionRepository institutionRepository;
    private final UserRepository userRepository;
    private final SuperAdmin superAdmin;
    private final SCIMService scimService;

    public UserAuthenticationFilter(InstitutionRepository institutionRepository, UserRepository userRepository, SuperAdmin superAdmin, SCIMService scimService) {
        this.institutionRepository = institutionRepository;
        this.userRepository = userRepository;
        this.superAdmin = superAdmin;
        this.scimService = scimService;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String requestURI = request.getRequestURI();
        if (requestURI.startsWith("/api/v1/public") || requestURI.startsWith("/api/v1/validations")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        BearerTokenAuthentication tokenAuthentication = (BearerTokenAuthentication)authentication;
        String httpMethod = request.getMethod().toLowerCase();
        String edupersonPrincipalName = (String)tokenAuthentication.getTokenAttributes().get("eduperson_principal_name");
        Optional optionalUser = this.userRepository.findByEduPersonPrincipalNameIgnoreCase(edupersonPrincipalName.trim());
        if (optionalUser.isPresent()) {
            User user = (User)optionalUser.get();
            tokenAuthentication.setDetails((Object)user);
            if (user.hasChanged(tokenAuthentication.getTokenAttributes())) {
                this.scimService.updateUserRequest(user);
            }
            user.setLastActivity(Instant.now());
            this.userRepository.save((Object)user);
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            Optional<String> optionalEppn = this.superAdmin.getUsers().stream().filter(eppn -> eppn.equalsIgnoreCase(edupersonPrincipalName)).findAny();
            if (optionalEppn.isPresent()) {
                Institution institution = this.getOrProvisionInstitution();
                User user = new User(institution, Authority.SUPER_ADMIN, tokenAuthentication.getTokenAttributes());
                this.userRepository.save((Object)user);
                tokenAuthentication.setDetails((Object)user);
                filterChain.doFilter(servletRequest, servletResponse);
            } else if (requestURI.startsWith("/api/v1/invitations") && (httpMethod.equals("post") || httpMethod.equals("get"))) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                this.responseForbidden(servletResponse, authentication, requestURI);
            }
        }
    }

    private void responseForbidden(ServletResponse servletResponse, Authentication authentication, String requestURI) {
        LOG.warn((Object)String.format("Returning 403 for authentication %s and requestURI %s", authentication, requestURI));
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader("Content-Type", "application/json");
        response.setStatus(HttpStatus.FORBIDDEN.value());
    }

    private Institution getOrProvisionInstitution() {
        Institution institution = this.superAdmin.getInstitution();
        return this.institutionRepository.findByHomeInstitutionIgnoreCase(institution.getHomeInstitution()).orElseGet(() -> (Institution)this.institutionRepository.save((Object)new Institution(institution)));
    }
}

