/*
 * Decompiled with CFR 0.152.
 */
package guests.validation;

import guests.validation.FormatValidator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class EmailFormatValidator
implements FormatValidator {
    private static final Pattern pattern = Pattern.compile("^[A-Z0-9._%&+-]+@[A-Z0-9.-]+\\.[A-Z]{2,16}$", 2);

    public boolean isValid(String subject) {
        return !StringUtils.hasText((String)subject) || pattern.matcher(subject).matches();
    }

    public String formatName() {
        return "email";
    }

    public Set<String> validateEmails(List<String> emails) {
        return emails.stream().filter(email -> pattern.matcher((CharSequence)email).matches()).collect(Collectors.toSet());
    }
}

