/*
 * Decompiled with CFR 0.152.
 */
package crypto;

import crypto.KeyStore;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAKeyStore
implements KeyStore {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public RSAKeyStore() {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair pair = generator.generateKeyPair();
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
    }

    public RSAKeyStore(String publicKeyContent, boolean ignore) {
        publicKeyContent = this.stripPublicKey(publicKeyContent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyContent));
        this.publicKey = kf.generatePublic(keySpecX509);
        this.privateKey = null;
    }

    public RSAKeyStore(String privateKeyContent) {
        privateKeyContent = this.stripPrivateKey(privateKeyContent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyContent));
        this.privateKey = kf.generatePrivate(keySpecPKCS8);
        this.publicKey = null;
    }

    @Override
    public String encryptAndEncode(String secret) {
        if (this.publicKey == null) {
            throw new IllegalArgumentException("For encryption a publicKey is required");
        }
        Cipher encryptCipher = Cipher.getInstance("RSA");
        encryptCipher.init(1, this.publicKey);
        byte[] secretMessageBytes = secret.getBytes(Charset.defaultCharset());
        byte[] encryptedMessageBytes = encryptCipher.doFinal(secretMessageBytes);
        return new String(Base64.encodeBase64((byte[])encryptedMessageBytes, (boolean)false, (boolean)true));
    }

    @Override
    public String decodeAndDecrypt(String encodedEncryptedSecret) {
        if (this.privateKey == null) {
            throw new IllegalArgumentException("For encryption a privateKey is required");
        }
        Cipher decryptCipher = Cipher.getInstance("RSA");
        decryptCipher.init(2, this.privateKey);
        byte[] decryptedMessageBytes = decryptCipher.doFinal(Base64.decodeBase64((String)encodedEncryptedSecret));
        return new String(decryptedMessageBytes, StandardCharsets.UTF_8);
    }

    @Override
    public boolean isEncryptedSecret(String input) {
        return input.length() >= 342 && this.validBase64(input);
    }

    private boolean validBase64(String input) {
        return Base64.decodeBase64((String)input).length > 0;
    }

    private String stripPublicKey(String publicKey) {
        return publicKey.replaceAll("\\n|-----BEGIN PUBLIC KEY-----|-----END PUBLIC KEY-----", "");
    }

    private String stripPrivateKey(String privateKey) {
        return privateKey.replaceAll("\\n|-----BEGIN PRIVATE KEY-----|-----END PRIVATE KEY-----", "");
    }
}

