/*
 * Decompiled with CFR 0.152.
 */
package crypto;

import crypto.HybridRSAKeyStore;
import crypto.KeyStore;
import crypto.RSAKeyStore;
import java.util.List;

public class CompoundKeyStore
implements KeyStore {
    private final List<KeyStore> keyStores;

    public CompoundKeyStore() {
        this.keyStores = List.of(new HybridRSAKeyStore(), new RSAKeyStore());
    }

    public CompoundKeyStore(String publicKeyContent, boolean ignore) {
        this.keyStores = List.of(new HybridRSAKeyStore(publicKeyContent, ignore), new RSAKeyStore(publicKeyContent, ignore));
    }

    public CompoundKeyStore(String privateKeyContent) {
        this.keyStores = List.of(new HybridRSAKeyStore(privateKeyContent), new RSAKeyStore(privateKeyContent));
    }

    @Override
    public String encryptAndEncode(String secret) {
        KeyStore hybridKeyStore = this.keyStores.stream().filter(keyStore -> keyStore instanceof HybridRSAKeyStore).findFirst().get();
        return hybridKeyStore.encryptAndEncode(secret);
    }

    @Override
    public String decodeAndDecrypt(String encodedEncryptedSecret) {
        KeyStore hybridKeyStore = this.keyStores.stream().filter(keyStore -> keyStore.isEncryptedSecret(encodedEncryptedSecret)).findFirst().orElseThrow(() -> new IllegalArgumentException("No keystore found for this secret"));
        return hybridKeyStore.decodeAndDecrypt(encodedEncryptedSecret);
    }

    @Override
    public boolean isEncryptedSecret(String input) {
        return this.keyStores.stream().anyMatch(keyStore -> keyStore.isEncryptedSecret(input));
    }
}

