/*
 * Decompiled with CFR 0.152.
 */
package crypto;

import crypto.EncryptionResult;
import crypto.KeyStore;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class HybridRSAKeyStore
implements KeyStore {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final SecretKey aesKey;

    public HybridRSAKeyStore() {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair pair = generator.generateKeyPair();
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        this.aesKey = this.generateAESKey();
    }

    public HybridRSAKeyStore(String publicKeyContent, boolean ignore) {
        publicKeyContent = this.stripPublicKey(publicKeyContent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyContent));
        this.publicKey = kf.generatePublic(keySpecX509);
        this.privateKey = null;
        this.aesKey = this.generateAESKey();
    }

    public HybridRSAKeyStore(String privateKeyContent) {
        privateKeyContent = this.stripPrivateKey(privateKeyContent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyContent));
        this.privateKey = kf.generatePrivate(keySpecPKCS8);
        this.publicKey = null;
        this.aesKey = null;
    }

    @Override
    public String encryptAndEncode(String secret) {
        if (this.publicKey == null) {
            throw new IllegalArgumentException("For encryption a publicKey is required");
        }
        Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipher.init(1, this.aesKey);
        byte[] encryptedSecretBytes = aesCipher.doFinal(secret.getBytes(StandardCharsets.UTF_8));
        byte[] iv = aesCipher.getIV();
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        rsaCipher.init(1, this.publicKey);
        byte[] encryptedAesKeyBytes = rsaCipher.doFinal(this.aesKey.getEncoded());
        Base64.Encoder encoder = Base64.getEncoder();
        return new EncryptionResult(encoder.encodeToString(encryptedSecretBytes), encoder.encodeToString(encryptedAesKeyBytes), encoder.encodeToString(iv)).serialized();
    }

    @Override
    public String decodeAndDecrypt(String serializedEncryptionResult) {
        if (this.privateKey == null) {
            throw new IllegalArgumentException("For encryption a privateKey is required");
        }
        EncryptionResult encryptionResult = EncryptionResult.deserialize(serializedEncryptionResult);
        String base64EncryptedSecret = encryptionResult.encryptedSecret();
        String base64EncryptedAesKey = encryptionResult.encryptedAesKey();
        String base64Iv = encryptionResult.iv();
        byte[] encryptedAesKeyBytes = Base64.getDecoder().decode(base64EncryptedAesKey);
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        rsaCipher.init(2, this.privateKey);
        byte[] decryptedAesKeyBytes = rsaCipher.doFinal(encryptedAesKeyBytes);
        SecretKeySpec aesKey = new SecretKeySpec(decryptedAesKeyBytes, "AES");
        byte[] encryptedSecretBytes = Base64.getDecoder().decode(base64EncryptedSecret);
        byte[] ivBytes = Base64.getDecoder().decode(base64Iv);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
        Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipher.init(2, (Key)aesKey, ivParameterSpec);
        byte[] decryptedSecretBytes = aesCipher.doFinal(encryptedSecretBytes);
        return new String(decryptedSecretBytes, StandardCharsets.UTF_8);
    }

    @Override
    public boolean isEncryptedSecret(String input) {
        long dotCount = input.chars().filter(c -> c == 46).count();
        if (dotCount != 2L) {
            return false;
        }
        EncryptionResult encryptionResult = EncryptionResult.deserialize(input);
        return encryptionResult.encryptedAesKey().length() == 344 && encryptionResult.iv().length() == 24;
    }

    private String stripPublicKey(String publicKey) {
        return publicKey.replaceAll("\\n|-----BEGIN PUBLIC KEY-----|-----END PUBLIC KEY-----", "");
    }

    private String stripPrivateKey(String privateKey) {
        return privateKey.replaceAll("\\n|-----BEGIN PRIVATE KEY-----|-----END PRIVATE KEY-----", "");
    }

    private SecretKey generateAESKey() throws Exception {
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(256);
        return generator.generateKey();
    }
}

