/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import manage.api.APIUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.exception.ResourceNotFoundException;
import manage.model.MetaData;
import manage.model.MetaDataUpdate;
import manage.repository.MetaDataRepository;
import manage.shibboleth.FederatedUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaDataController {
    public static final String REQUESTED_ATTRIBUTES = "REQUESTED_ATTRIBUTES";
    @Autowired
    private MetaDataRepository metaDataRepository;
    @Autowired
    private MetaDataAutoConfiguration metaDataAutoConfiguration;

    @GetMapping(value={"/client/template/{type}"})
    public MetaData template(@PathVariable(value="type") String type) {
        return new MetaData(type, (Map)Map.class.cast(this.metaDataAutoConfiguration.metaDataTemplate(type)));
    }

    @GetMapping(value={"/client/metadata/{type}/{id}"})
    public MetaData get(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        MetaData metaData = this.metaDataRepository.findById(id, type);
        if (metaData == null) {
            throw new ResourceNotFoundException(String.format("MetaData type %s with id %s does not exist", type, id));
        }
        return metaData;
    }

    @GetMapping(value={"/client/metadata/configuration"})
    public List<Map<String, Object>> configuration() {
        return this.metaDataAutoConfiguration.schemaRepresentations();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/metadata"})
    public MetaData post(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        this.validate(metaData);
        metaData.initial(UUID.randomUUID().toString(), federatedUser.getUid());
        return this.metaDataRepository.save(metaData);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/metadata/{type}/{id}"})
    public boolean remove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData current = this.metaDataRepository.findById(id, type);
        this.metaDataRepository.remove(current);
        return true;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata"})
    @Transactional
    public MetaData put(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        this.validate(metaData);
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest(federatedUser.getUid());
        this.metaDataRepository.update(metaData);
        return metaData;
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"internal/metadata"})
    @Transactional
    public MetaData update(@Validated @RequestBody MetaDataUpdate metaDataUpdate, APIUser apiUser) throws JsonProcessingException {
        String id = metaDataUpdate.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        previous.revision(UUID.randomUUID().toString());
        MetaData metaData = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        metaData.promoteToLatest(apiUser.getName());
        metaData.merge(metaDataUpdate);
        this.validate(metaData);
        this.metaDataRepository.save(previous);
        this.metaDataRepository.update(metaData);
        return metaData;
    }

    @GetMapping(value={"/client/revisions/{type}/{parentId}"})
    public List<MetaData> revisions(@PathVariable(value="type") String type, @PathVariable(value="parentId") String parentId) {
        return this.metaDataRepository.revisions(type.concat("_revision"), parentId);
    }

    @GetMapping(value={"/client/autocomplete/{type}"})
    public List<Map> autoCompleteEntities(@PathVariable(value="type") String type, @RequestParam(value="query") String query) {
        return this.metaDataRepository.autoComplete(type, query);
    }

    @GetMapping(value={"/client/whiteListing/{type}"})
    public List<Map> whiteListing(@PathVariable(value="type") String type) {
        return this.metaDataRepository.whiteListing(type);
    }

    @PostMapping(value={"/client/search/{type}", "/internal/search/{type}"})
    public List<Map> searchEntities(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties) {
        List requestedAttributes = (List)List.class.cast(properties.getOrDefault(REQUESTED_ATTRIBUTES, new ArrayList()));
        properties.remove(REQUESTED_ATTRIBUTES);
        return this.metaDataRepository.search(type, properties, requestedAttributes);
    }

    private void validate(MetaData metaData) throws JsonProcessingException {
        String json = this.metaDataAutoConfiguration.getObjectMapper().writeValueAsString((Object)metaData.getData());
        this.metaDataAutoConfiguration.validate(json, metaData.getType());
    }
}

