/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.sql.DataSource;
import manage.conf.Features;
import manage.conf.Product;
import manage.conf.Push;
import manage.exception.EndpointNotAllowed;
import manage.format.EngineBlockFormatter;
import manage.mail.MailBox;
import manage.migration.JanusMigration;
import manage.migration.JanusMigrationValidation;
import manage.model.MetaData;
import manage.push.Delta;
import manage.push.PrePostComparator;
import manage.repository.MetaDataRepository;
import manage.shibboleth.FederatedUser;
import manage.web.PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class SystemController {
    private static final FederatedUser FEDERATED_USER = new FederatedUser("system", "system", "system", AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ADMIN"}), Arrays.asList(Features.values()), Product.DEFAULT, new Push("https://nope", "push"));
    private RestTemplate restTemplate;
    private String pushUser;
    private String pushPassword;
    private String pushUri;
    private JanusMigrationValidation janusMigrationValidation;
    private JanusMigration janusMigration;
    private MetaDataRepository metaDataRepository;
    private JdbcTemplate ebJdbcTemplate;
    private Environment environment;
    private ObjectMapper objectMapper;
    private MailBox mailBox;
    private PrePostComparator prePostComparator = new PrePostComparator();

    @Autowired
    public SystemController(JanusMigration janusMigration, JanusMigrationValidation janusMigrationValidation, MetaDataRepository metaDataRepository, @Qualifier(value="ebDataSource") DataSource ebDataSource, @Value(value="${push.url}") String pushUri, @Value(value="${push.user}") String user, @Value(value="${push.password}") String password, @Value(value="${manage_cronjob_minutes}") int everyMinutes, @Value(value="${manage_cronjobmaster}") boolean cronJobResponsible, Environment environment, ObjectMapper objectMapper, MailBox mailBox) throws MalformedURLException {
        this.janusMigration = janusMigration;
        this.janusMigrationValidation = janusMigrationValidation;
        this.metaDataRepository = metaDataRepository;
        this.pushUri = pushUri;
        this.pushUser = user;
        this.pushPassword = password;
        this.restTemplate = new RestTemplate(this.getRequestFactory());
        this.ebJdbcTemplate = new JdbcTemplate(ebDataSource);
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.mailBox = mailBox;
        if (cronJobResponsible) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.migrateAndPush(), 0L, everyMinutes, TimeUnit.MINUTES);
        }
    }

    private void migrateAndPush() {
        try {
            this.janusMigration.doMigrate();
            ResponseEntity responseEntity = this.push(FEDERATED_USER);
            List realDeltas = (List)((Map)responseEntity.getBody()).get("deltas");
            if (!responseEntity.getStatusCode().equals((Object)HttpStatus.OK) || !realDeltas.isEmpty()) {
                this.mailBox.sendDeltaPushMail(realDeltas);
            }
        }
        catch (IOException | RuntimeException | MessagingException throwable) {
            // empty catch block
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/migrate"})
    public List<Map<String, Long>> migrate(FederatedUser federatedUser) {
        if (!federatedUser.featureAllowed(Features.MIGRATION)) {
            throw new EndpointNotAllowed();
        }
        return this.janusMigration.doMigrate();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreview"})
    public Map<String, Map<String, Map<String, Object>>> pushPreview(FederatedUser federatedUser) {
        if (!federatedUser.featureAllowed(Features.PUSH_PREVIEW)) {
            throw new EndpointNotAllowed();
        }
        EngineBlockFormatter formatter = new EngineBlockFormatter();
        HashMap<String, Map<String, Map<String, Object>>> results = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap connections = new HashMap();
        results.put("connections", connections);
        List serviceProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "saml20_sp");
        serviceProviders.forEach(sp -> connections.put(sp.getId(), formatter.parseServiceProvider(sp)));
        List identityProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "saml20_idp");
        identityProviders.forEach(idp -> connections.put(idp.getId(), formatter.parseIdentityProvider(idp)));
        return results;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/push"})
    public ResponseEntity<Map> push(FederatedUser federatedUser) throws IOException {
        if (!federatedUser.featureAllowed(Features.PUSH)) {
            throw new EndpointNotAllowed();
        }
        if (this.environment.acceptsProfiles(new String[]{"dev"})) {
            Map map = (Map)this.objectMapper.readValue(new ClassPathResource("mock/mock_eb_push_repsonse.json").getInputStream(), Map.class);
            return new ResponseEntity((Object)map, HttpStatus.OK);
        }
        List preProvidersData = this.ebJdbcTemplate.queryForList("SELECT * FROM sso_provider_roles_eb5 ORDER BY id ASC");
        Map json = this.pushPreview(federatedUser);
        ResponseEntity response = this.restTemplate.postForEntity(this.pushUri, (Object)json, String.class, new Object[0]);
        HttpStatus statusCode = response.getStatusCode();
        List postProvidersData = this.ebJdbcTemplate.queryForList("SELECT * FROM sso_provider_roles_eb5 ORDER BY id ASC");
        Set deltas = this.prePostComparator.compare(preProvidersData, postProvidersData);
        List<String> knownDeltas = Arrays.asList("id", "name_id_formats", "attribute_release_policy", "allowed_idp_entity_ids");
        List realDeltas = deltas.stream().filter(delta -> !knownDeltas.contains(delta.getAttribute())).collect(Collectors.toList());
        realDeltas.sort(Comparator.comparing(Delta::getEntityId));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", statusCode);
        result.put("response", response);
        result.put("deltas", realDeltas);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/validate"})
    public Map<String, Object> validate(FederatedUser federatedUser) {
        if (!federatedUser.featureAllowed(Features.VALIDATION)) {
            throw new EndpointNotAllowed();
        }
        return this.janusMigrationValidation.validateMigration();
    }

    private ClientHttpRequestFactory getRequestFactory() throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(10L, TimeUnit.SECONDS);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.pushUser, this.pushPassword));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, this.pushUri);
    }
}

