/*
 * Decompiled with CFR 0.152.
 */
package manage.format;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import manage.model.MetaData;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class Exporter {
    private static final MustacheFactory MUSTACHE_FACTORY = new DefaultMustacheFactory();
    private final ResourceLoader resourceLoader;
    private final String metadataExportPath;
    private final Clock clock;
    static final List<String> excludedDataFields = Arrays.asList("id", "eid", "revisionid", "user", "created", "ip", "revisionnote", "notes");

    public Exporter(Clock clock, ResourceLoader resourceLoader, String metadataExportPath) {
        this.clock = clock;
        this.resourceLoader = resourceLoader;
        this.metadataExportPath = metadataExportPath;
    }

    public String exportToXml(MetaData metaData) throws IOException {
        String path = String.format("%s/%s.xml", this.metadataExportPath, metaData.getType());
        Resource resource = this.resourceLoader.getResource(path);
        String template = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
        Mustache mustache = MUSTACHE_FACTORY.compile((Reader)new StringReader(template), metaData.getType());
        StringWriter writer = new StringWriter();
        try {
            Map data = (Map)Map.class.cast(metaData.getData());
            this.addOrganizationName(data);
            this.addValidUntil(data);
            this.addAttributeConsumingService(data);
            mustache.execute((Writer)writer, (Object)data).flush();
            String xml = writer.toString();
            return xml;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> exportToMap(MetaData metaData, boolean nested) {
        Map data = (Map)Map.class.cast(metaData.getData());
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        if (nested) {
            data.forEach((key, value) -> this.addKeyValue(key, value, result));
        } else {
            result.putAll(data);
            result.put("metaDataFields", new TreeMap((Map)Map.class.cast(result.get("metaDataFields"))));
        }
        excludedDataFields.forEach(result::remove);
        result.put("type", metaData.getType().replaceAll("_", "-"));
        return result;
    }

    private void addKeyValue(String key, Object value, Map<String, Object> result) {
        if (value instanceof Map) {
            TreeMap map = new TreeMap();
            result.put((String)key, map);
            ((Map)Map.class.cast(value)).forEach((mapKey, mapValue) -> this.addKeyValue((String)String.class.cast(mapKey), mapValue, map));
            return;
        }
        if (value instanceof List) {
            if ("allowedEntities".equals(key) || "disableConsent".equals(key)) {
                List values = (List)List.class.cast(value);
                ArrayList list = new ArrayList();
                result.put((String)key, list);
                values.forEach(mapValue -> list.add(mapValue.get("name")));
                return;
            }
            result.put((String)key, (Object)value);
            return;
        }
        List<String> parts = Arrays.asList(key.split(":"));
        if (parts.size() == 1) {
            result.put((String)key, (Object)value);
        } else {
            Map reference = result;
            List<String> subParts = parts.subList(0, parts.size() - 1);
            for (String subKey : subParts) {
                if (!reference.containsKey(subKey)) {
                    reference.put((String)subKey, new TreeMap());
                }
                reference = (Map)Map.class.cast(reference.get(subKey));
            }
            reference.put((String)parts.get(parts.size() - 1), (Object)value);
        }
    }

    private void addValidUntil(Map data) {
        ZonedDateTime now = ZonedDateTime.of(LocalDateTime.now(this.clock), ZoneId.systemDefault());
        String validUntil = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(now.plusYears(1L));
        data.put("validUntil", validUntil);
    }

    private void addOrganizationName(Map data) {
        String url;
        String displayName;
        Map metaDataFields = (Map)Map.class.cast(data.get("metaDataFields"));
        String name = (String)String.class.cast(metaDataFields.computeIfAbsent("OrganizationName:en", key -> metaDataFields.get("OrganizationName:nl")));
        if (StringUtils.hasText((String)name)) {
            metaDataFields.put("OrganizationName", name);
        }
        if (StringUtils.hasText((String)(displayName = (String)String.class.cast(metaDataFields.computeIfAbsent("OrganizationDisplayName:en", key -> metaDataFields.get("OrganizationDisplayName:nl")))))) {
            metaDataFields.put("OrganizationDisplayName", displayName);
        }
        if (StringUtils.hasText((String)(url = (String)String.class.cast(metaDataFields.computeIfAbsent("OrganizationURL:en", key -> metaDataFields.get("OrganizationURL:nl")))))) {
            metaDataFields.put("OrganizationURL", url);
        }
    }

    private void addAttributeConsumingService(Map data) {
        Map metaDataFields = (Map)Map.class.cast(data.get("metaDataFields"));
        String name = (String)String.class.cast(metaDataFields.computeIfAbsent("name:en", key -> metaDataFields.get("name:nl")));
        String description = (String)String.class.cast(metaDataFields.computeIfAbsent("description:en", key -> metaDataFields.get("description:nl")));
        boolean arpAttributes = false;
        Map arp = (Map)Map.class.cast(data.get("arp"));
        if (((Boolean)Boolean.class.cast(arp.getOrDefault("enabled", false))).booleanValue()) {
            Map attributes = (Map)Map.class.cast(arp.getOrDefault("attributes", new HashMap()));
            boolean bl = arpAttributes = !attributes.isEmpty();
            if (arpAttributes) {
                data.put("requestedAttributes", attributes.keySet());
            }
        }
        data.put("AttributeConsumingService", arpAttributes || StringUtils.hasText((String)name) || StringUtils.hasText((String)description));
    }
}

