/*
 * Decompiled with CFR 0.152.
 */
package manage.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import manage.conf.MetaDataAutoConfiguration;
import manage.migration.EntityType;
import org.springframework.core.io.Resource;

public class MetaDataFeedParser {
    private static final List<String> languages = Arrays.asList("en", "nl");
    private static final String ATTRIBUTES = "attributes";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Map<String, Object> importXML(Resource xml, Optional<String> entityIDOptional, MetaDataAutoConfiguration metaDataAutoConfiguration) throws XMLStreamException, IOException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(xml.getInputStream());
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        TreeMap metaDataFields = new TreeMap();
        result.put("metaDataFields", metaDataFields);
        boolean inKeyDescriptor = false;
        boolean inContact = true;
        boolean inCorrectEntityDescriptor = !entityIDOptional.isPresent();
        boolean inAttributeConsumingService = false;
        boolean isSp = false;
        String entityType = EntityType.IDP.getJanusDbValue();
        result.put("type", entityType);
        HashSet hashSet = new HashSet();
        block60: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "EntityDescriptor": {
                            Optional optional = this.getAttributeValue(reader, "entityID");
                            if (!optional.isPresent()) break;
                            if (entityIDOptional.isPresent()) {
                                inCorrectEntityDescriptor = entityIDOptional.get().equalsIgnoreCase((String)optional.get());
                            }
                            if (!inCorrectEntityDescriptor) break;
                            result.put("entityid", optional.get());
                            continue block60;
                        }
                        case "SPSSODescriptor": {
                            if (inCorrectEntityDescriptor) {
                                isSp = true;
                                Set set = this.arpKeys(EntityType.SP, metaDataAutoConfiguration, isSp);
                                TreeMap<String, Serializable> arp = new TreeMap<String, Serializable>();
                                arp.put("enabled", Boolean.valueOf(false));
                                TreeMap attributes = new TreeMap();
                                arp.put(ATTRIBUTES, attributes);
                                result.put("arp", arp);
                                entityType = EntityType.SP.getJanusDbValue();
                                result.put("type", entityType);
                            }
                        }
                        case "KeyDescriptor": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            if (!this.attributeValueMatches(reader, "use", "signing") && this.getAttributeValue(reader, "use").isPresent()) break;
                            inKeyDescriptor = true;
                            continue block60;
                        }
                        case "X509Certificate": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            if (!inKeyDescriptor) break;
                            inKeyDescriptor = false;
                            String cert = reader.getElementText();
                            this.addCert(metaDataFields, cert);
                            continue block60;
                        }
                        case "SingleLogoutService": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            if (!isSp) break;
                            this.addMetaDataField(metaDataFields, reader, "Binding", "SingleLogoutService_Binding");
                            this.addMetaDataField(metaDataFields, reader, "Location", "SingleLogoutService_Location");
                            continue block60;
                        }
                        case "AssertionConsumerService": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            if (!isSp) break;
                            Optional bindingOpt = this.getAttributeValue(reader, "Binding");
                            bindingOpt.ifPresent(binding -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Binding", 10, binding));
                            Optional locationOpt = this.getAttributeValue(reader, "Location");
                            locationOpt.ifPresent(location -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Location", 10, location));
                            Optional indexOpt = this.getAttributeValue(reader, "index");
                            indexOpt.ifPresent(index -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:index", 10, index));
                            continue block60;
                        }
                        case "SingleSignOnService": {
                            if (!inCorrectEntityDescriptor) break;
                            if (isSp) continue block60;
                            Optional bindingOpt = this.getAttributeValue(reader, "Binding");
                            bindingOpt.ifPresent(binding -> this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Binding", 10, binding));
                            Optional locationOpt = this.getAttributeValue(reader, "Location");
                            locationOpt.ifPresent(location -> this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Location", 10, location));
                            continue block60;
                        }
                        case "RegistrationInfo": {
                            if (!inCorrectEntityDescriptor) break;
                            this.getAttributeValue(reader, "registrationAuthority").ifPresent(authority -> metaDataFields.put("mdrpi:RegistrationInfo", authority));
                            continue block60;
                        }
                        case "RegistrationPolicy": {
                            if (!inCorrectEntityDescriptor) break;
                            this.addLanguageElement(metaDataFields, reader, "mdrpi:RegistrationPolicy");
                            continue block60;
                        }
                        case "AttributeConsumingService": {
                            inAttributeConsumingService = inCorrectEntityDescriptor;
                            continue block60;
                        }
                        case "ServiceName": {
                            if (!inAttributeConsumingService) break;
                            this.addLanguageElement(metaDataFields, reader, "name");
                            continue block60;
                        }
                        case "ServiceDescription": {
                            if (!inAttributeConsumingService) break;
                            this.addLanguageElement(metaDataFields, reader, "description");
                            continue block60;
                        }
                        case "RequestedAttribute": {
                            void var14_15;
                            if (!inAttributeConsumingService || !isSp) break;
                            this.addArpAttribute(result, reader, (Set)var14_15);
                            continue block60;
                        }
                        case "OrganizationName": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationName");
                            continue block60;
                        }
                        case "OrganizationDisplayName": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationDisplayName");
                            continue block60;
                        }
                        case "OrganizationURL": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationURL");
                            continue block60;
                        }
                        case "ContactPerson": {
                            if (!inCorrectEntityDescriptor) continue block60;
                            String contactType = this.getAttributeValue(reader, "contactType").orElse("other");
                            this.addMultiplicity(metaDataFields, "contacts:%s:contactType", 4, contactType);
                            inContact = true;
                            continue block60;
                        }
                        case "GivenName": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:givenName", 4, reader.getElementText());
                            continue block60;
                        }
                        case "SurName": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:surName", 4, reader.getElementText());
                            continue block60;
                        }
                        case "EmailAddress": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:emailAddress", 4, reader.getElementText().replaceAll(Pattern.quote("mailto:"), ""));
                            continue block60;
                        }
                        case "TelephoneNumber": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:telephoneNumber", 4, reader.getElementText());
                        }
                    }
                    continue block60;
                }
                case 2: {
                    switch (reader.getLocalName()) {
                        case "ContactPerson": {
                            inContact = false;
                            break;
                        }
                        case "AttributeConsumingService": {
                            inAttributeConsumingService = false;
                            break;
                        }
                        case "EntityDescriptor": {
                            if (!inCorrectEntityDescriptor) break;
                            return result;
                        }
                    }
                    continue block60;
                }
            }
        }
        return result;
    }

    private Set<String> arpKeys(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        Map arpAttributes;
        Map schema = metaDataAutoConfiguration.schemaRepresentation(type);
        Map map = arpAttributes = isSp ? (Map)Map.class.cast(schema.get("properties")) : new HashMap();
        if (isSp) {
            for (String s : Arrays.asList("arp", "properties", ATTRIBUTES, "properties")) {
                arpAttributes = (Map)Map.class.cast(arpAttributes.get(s));
            }
        }
        return arpAttributes.keySet();
    }

    private void addArpAttribute(Map<String, Object> result, XMLStreamReader reader, Set<String> arpKeys) {
        Optional friendlyName = this.getAttributeValue(reader, "FriendlyName");
        Optional name = this.getAttributeValue(reader, "Name");
        if (friendlyName.isPresent()) {
            this.doAddArpAttribute(result, arpKeys, (String)friendlyName.get());
        } else if (name.isPresent()) {
            this.doAddArpAttribute(result, arpKeys, (String)name.get());
        }
    }

    private void doAddArpAttribute(Map<String, Object> result, Set<String> arpKeys, String friendlyName) {
        Map arp = (Map)Map.class.cast(result.getOrDefault("arp", new TreeMap()));
        arp.put("enabled", true);
        Map attributes = (Map)Map.class.cast(arp.getOrDefault(ATTRIBUTES, new TreeMap()));
        arpKeys.stream().filter(arpKey -> arpKey.endsWith(friendlyName)).findFirst().ifPresent(arpKey -> {
            List arpEntry = (List)List.class.cast(attributes.getOrDefault(arpKey, new ArrayList()));
            HashMap<String, String> arpValue = new HashMap<String, String>();
            arpValue.put("source", "idp");
            arpValue.put("value", "*");
            arpEntry.add(arpValue);
            attributes.put(arpKey, arpEntry);
        });
        arp.put(ATTRIBUTES, attributes);
        result.put("arp", arp);
    }

    private void addMetaDataField(Map<String, String> metaDataFields, XMLStreamReader reader, String attributeName, String metaDataKey) {
        Optional optional = this.getAttributeValue(reader, attributeName);
        optional.ifPresent(value -> metaDataFields.put(metaDataKey, (String)value));
    }

    private void addLanguageElement(Map<String, String> metaDataFields, XMLStreamReader reader, String elementName) throws XMLStreamException {
        String language = this.getAttributeValue(reader, "lang").orElse("en");
        if (languages.contains(language)) {
            metaDataFields.put(String.format("%s:%s", elementName, language), reader.getElementText());
        }
    }

    private void addMultiplicity(Map<String, String> result, String format, int multiplicity, String value) {
        List keys = IntStream.range(0, multiplicity).mapToObj(nbr -> String.format(format, nbr)).collect(Collectors.toList());
        long count = result.keySet().stream().filter(key -> keys.contains(key)).count();
        if (count < (long)keys.size()) {
            result.put((String)keys.get((int)count), value);
        }
    }

    private void addCert(Map<String, String> result, String cert) {
        List<String> certDataKeys = Arrays.asList("certData", "certData2", "certData3");
        long count = result.keySet().stream().filter(certDataKeys::contains).count();
        if (count < (long)certDataKeys.size()) {
            result.put(certDataKeys.get((int)count), cert);
        }
    }

    private Optional<String> getAttributeValue(XMLStreamReader reader, String attributeName) {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            QName qName = reader.getAttributeName(i);
            if (!qName.getLocalPart().equalsIgnoreCase(attributeName)) continue;
            return Optional.of(reader.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()));
        }
        return Optional.empty();
    }

    private boolean attributeValueMatches(XMLStreamReader reader, String attributeName, String value) {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            QName qName = reader.getAttributeName(i);
            if (!qName.getLocalPart().equalsIgnoreCase(attributeName)) continue;
            return reader.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()).equalsIgnoreCase(value);
        }
        return false;
    }
}

