/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import com.github.mongobee.Mongobee;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import manage.conf.IndexConfiguration;
import manage.conf.MetaDataAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;

@Configuration
@ChangeLog
public class MongobeeConfiguration {
    public static final String REVISION_POSTFIX = "_revision";
    @Autowired
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    @Autowired
    private MappingMongoConverter mongoConverter;
    private static MetaDataAutoConfiguration staticMetaDataAutoConfiguration;

    @PostConstruct
    public void setUpMongoEscapeCharacterConversion() {
        this.mongoConverter.setMapKeyDotReplacement("@");
    }

    @Bean
    public Mongobee mongobee(@Value(value="${spring.data.mongodb.uri}") String uri) {
        Mongobee runner = new Mongobee(uri);
        runner.setChangeLogsScanPackage("mr.mongo");
        staticMetaDataAutoConfiguration = this.metaDataAutoConfiguration;
        return runner;
    }

    @ChangeSet(order="001", id="createCollections", author="Okke Harsta", runAlways=true)
    public void createCollections(MongoTemplate mongoTemplate) {
        Set schemaNames = staticMetaDataAutoConfiguration.schemaNames();
        schemaNames.forEach(schema -> {
            if (!mongoTemplate.collectionExists(schema)) {
                mongoTemplate.createCollection(schema);
                staticMetaDataAutoConfiguration.indexConfigurations(schema).stream().map(arg_0 -> this.indexDefinition(arg_0)).forEach(arg_0 -> ((IndexOperations)mongoTemplate.indexOps(schema)).ensureIndex(arg_0));
                String revision = schema.concat(REVISION_POSTFIX);
                mongoTemplate.createCollection(revision);
                mongoTemplate.indexOps(revision).ensureIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
            }
        });
    }

    private IndexDefinition indexDefinition(IndexConfiguration indexConfiguration) {
        Index index = new Index();
        indexConfiguration.getFields().forEach(field -> index.on("data.".concat((String)field), Sort.Direction.ASC));
        index.named(indexConfiguration.getName());
        if (indexConfiguration.isUnique()) {
            index.unique();
        }
        return index;
    }
}

