/*
 * Decompiled with CFR 0.152.
 */
package manage.repository;

import java.util.List;
import java.util.Map;
import manage.model.MetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MetaDataRepository {
    private static final int AUTOCOMPLETE_LIMIT = 15;
    private MongoTemplate mongoTemplate;

    @Autowired
    public MetaDataRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public MetaData findById(String id, String type) {
        return (MetaData)this.mongoTemplate.findById((Object)id, MetaData.class, type);
    }

    public MetaData save(MetaData metaData) {
        this.mongoTemplate.insert((Object)metaData, metaData.getType());
        return metaData;
    }

    public void remove(MetaData metaData) {
        this.mongoTemplate.remove((Object)metaData, metaData.getType());
    }

    public List<MetaData> revisions(String type, String parentId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"revision.parentId").is((Object)parentId));
        return this.mongoTemplate.find(query, MetaData.class, type);
    }

    public void update(MetaData metaDate) {
        this.mongoTemplate.save((Object)metaDate, metaDate.getType());
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public List<Map> autoComplete(String type, String search) {
        Query query = this.queryWithSamlFields();
        query.limit(15);
        Criteria criteria = new Criteria();
        query.addCriteria((CriteriaDefinition)criteria.orOperator(new Criteria[]{this.regex("data.entityid", search), this.regex("data.metaDataFields.name:en", search), this.regex("data.metaDataFields.name:nl", search)}));
        return this.mongoTemplate.find(query, Map.class, type);
    }

    private Criteria regex(String key, String search) {
        return Criteria.where((String)key).regex(".*" + search + ".*", "i");
    }

    public List<Map> search(String type, Map<String, Object> properties, List<String> requestedAttributes) {
        Query query = this.queryWithSamlFields();
        requestedAttributes.forEach(requestedAttribute -> query.fields().include("data.".concat((String)requestedAttribute)));
        properties.forEach((key, value) -> {
            if (value instanceof String && !StringUtils.hasText((String)((String)String.class.cast(value)))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.".concat((String)key)).exists(false));
            } else if ("*".equals(value)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.".concat((String)key)).regex(".*", "i"));
            } else if (value instanceof String && ((String)String.class.cast(value)).contains("*")) {
                String queryString = (String)String.class.cast(value);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.".concat((String)key)).regex(queryString, "i"));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.".concat((String)key)).is(value));
            }
        });
        return this.mongoTemplate.find(query, Map.class, type);
    }

    public List<Map> whiteListing(String type) {
        Query query = this.queryWithSamlFields();
        query.fields().include("data.allowedall").include("data.state").include("data.allowedEntities");
        return this.mongoTemplate.find(query, Map.class, type);
    }

    private Query queryWithSamlFields() {
        Query query = new Query();
        query.fields().include("data.state").include("data.entityid").include("data.metaDataFields.name:en").include("data.metaDataFields.name:nl");
        return query;
    }
}

