/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mongobee.Mongobee;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import manage.conf.IndexConfiguration;
import manage.conf.MetaDataAutoConfiguration;
import manage.migration.EntityType;
import manage.model.MetaData;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

@Configuration
@ChangeLog
public class MongobeeConfiguration {
    public static final String REVISION_POSTFIX = "_revision";
    private static final Logger LOG = LoggerFactory.getLogger(MongobeeConfiguration.class);
    private static MetaDataAutoConfiguration staticMetaDataAutoConfiguration;
    @Autowired
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    @Autowired
    private MappingMongoConverter mongoConverter;

    @PostConstruct
    public void setUpMongoEscapeCharacterConversion() {
        this.mongoConverter.setMapKeyDotReplacement("@");
    }

    @Bean
    public Mongobee mongobee(@Value(value="${spring.data.mongodb.uri}") String uri) {
        Mongobee runner = new Mongobee(uri);
        runner.setChangeLogsScanPackage("manage.mongo");
        staticMetaDataAutoConfiguration = this.metaDataAutoConfiguration;
        return runner;
    }

    @ChangeSet(order="001", id="createCollections", author="Okke Harsta", runAlways=true)
    public void createCollections(MongoTemplate mongoTemplate) {
        Set schemaNames = staticMetaDataAutoConfiguration.schemaNames();
        schemaNames.forEach(schema -> {
            if (!mongoTemplate.collectionExists(schema)) {
                mongoTemplate.createCollection(schema);
                staticMetaDataAutoConfiguration.indexConfigurations(schema).stream().map(arg_0 -> this.indexDefinition(arg_0)).forEach(arg_0 -> ((IndexOperations)mongoTemplate.indexOps(schema)).ensureIndex(arg_0));
                String revision = schema.concat(REVISION_POSTFIX);
                mongoTemplate.createCollection(revision);
                mongoTemplate.indexOps(revision).ensureIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
            }
        });
    }

    @ChangeSet(order="002", id="createSingleTenantTemplates", author="Okke Harsta")
    public void createSingleTenantTemplates(MongoTemplate mongoTemplate) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath:single_tenant_templates/*.json");
        Arrays.asList(resources).forEach(res -> this.createSingleTenantTemplate(mongoTemplate, res, objectMapper));
    }

    @ChangeSet(order="003", id="reCreateSingleTenantTemplates", author="Okke Harsta")
    public void reCreateSingleTenantTemplates(MongoTemplate mongoTemplate) throws IOException {
        mongoTemplate.findAllAndRemove(new Query(), "single_tenant_template");
        mongoTemplate.findAllAndRemove(new Query(), "single_tenant_template_revision");
        this.createSingleTenantTemplates(mongoTemplate);
    }

    @ChangeSet(order="004", id="importCSA", author="Okke Harsta")
    public void inportCsaSettings(MongoTemplate mongoTemplate) throws Exception {
        this.doImportCsaSettings(mongoTemplate);
    }

    @ChangeSet(order="005", id="importCSA", author="Okke Harsta")
    public void reImportCsaSettings(MongoTemplate mongoTemplate) throws Exception {
        this.doImportCsaSettings(mongoTemplate);
    }

    private void doImportCsaSettings(MongoTemplate mongoTemplate) throws IOException {
        String type = EntityType.SP.getType();
        String content = IOUtils.toString((InputStream)new ClassPathResource("csa_export/csp.csv").getInputStream(), (Charset)Charset.defaultCharset());
        List<String> lines = Arrays.asList(content.split("\n"));
        HashMap<String, String> mappedLicenseStatus = new HashMap<String, String>();
        mappedLicenseStatus.put("HAS_LICENSE_SP", "license_required_by_service_provider");
        mappedLicenseStatus.put("NOT_NEEDED", "license_not_required");
        mappedLicenseStatus.put("HAS_LICENSE_SURFMARKET", "license_available_through_surfmarket");
        mappedLicenseStatus.put("UNKNOWN", "license_required_by_service_provider");
        lines.forEach(l -> {
            List<String> columns = Arrays.asList(l.split(","));
            String entityId = columns.get(0);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.entityid").is((Object)entityId));
            List metaDatas = mongoTemplate.find(query, MetaData.class, type);
            if (metaDatas != null && metaDatas.size() > 0) {
                MetaData metaData = (MetaData)metaDatas.get(0);
                Map metaDataFields = (Map)metaData.getData().get("metaDataFields");
                boolean normenKaderPresent = columns.get(1).equals("1");
                metaDataFields.put("coin:privacy:gdpr_is_in_wiki", normenKaderPresent);
                String licenseStatus = mappedLicenseStatus.getOrDefault(columns.get(2), "license_required_by_service_provider");
                metaDataFields.put("coin:license_status", licenseStatus);
                boolean strongAuthentication = columns.get(3).equals("1");
                metaDataFields.put("coin:requires_strong_authentication", strongAuthentication);
                MetaData previous = (MetaData)mongoTemplate.findById((Object)metaData.getId(), MetaData.class, type);
                previous.revision(UUID.randomUUID().toString());
                mongoTemplate.insert((Object)previous, previous.getType());
                metaData.promoteToLatest("CSA import migration");
                mongoTemplate.save((Object)metaData, metaData.getType());
                LOG.info("Migrated {} to new revision in CSA import", (Object)entityId);
            }
        });
    }

    private void createSingleTenantTemplate(MongoTemplate mongoTemplate, Resource resource, ObjectMapper objectMapper) {
        Map template = this.readTemplate(resource, objectMapper);
        HashMap data = new HashMap();
        data.put("entityid", template.get("entityid"));
        data.put("state", template.get("workflowState"));
        HashMap<String, Serializable> arp = new HashMap<String, Serializable>();
        data.put("arp", arp);
        boolean enabled = template.containsKey("attributes");
        arp.put("enabled", Boolean.valueOf(enabled));
        HashMap attributes = new HashMap();
        if (enabled) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("source", "idp");
            source.put("value", "*");
            List values = Collections.singletonList(source);
            ((List)List.class.cast(template.get("attributes"))).forEach(attr -> attributes.put(((String)attr).replaceAll("\\.", "@"), values));
        }
        arp.put("attributes", attributes);
        Arrays.asList("entityid", "workflowState", "attributes").forEach(none -> template.remove(none));
        template.keySet().forEach(key -> {
            if (key.contains(".")) {
                template.put(key.replaceAll("\\.", "@"), template.get(key));
                template.remove(key);
            }
        });
        data.put("metaDataFields", template);
        MetaData metaData = new MetaData("single_tenant_template", data);
        metaData.initial(UUID.randomUUID().toString(), "auto-generated");
        mongoTemplate.insert((Object)metaData, metaData.getType());
    }

    private Map<String, Object> readTemplate(Resource resource, ObjectMapper objectMapper) {
        Map template;
        try {
            template = (Map)objectMapper.readValue(resource.getInputStream(), Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return template;
    }

    private IndexDefinition indexDefinition(IndexConfiguration indexConfiguration) {
        Index index = new Index();
        indexConfiguration.getFields().forEach(field -> index.on("data.".concat((String)field), Sort.Direction.ASC));
        index.named(indexConfiguration.getName());
        if (indexConfiguration.isUnique()) {
            index.unique();
        }
        return index;
    }
}

