/*
 * Decompiled with CFR 0.152.
 */
package manage.push;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import manage.push.Delta;

public class PrePostComparator {
    public Set<Delta> compare(List<Map<String, Object>> preProvidersData, List<Map<String, Object>> postProvidersData) {
        HashSet<Delta> deltas = new HashSet<Delta>();
        this.doCompare(deltas, preProvidersData, postProvidersData, false);
        this.doCompare(deltas, postProvidersData, preProvidersData, true);
        return deltas;
    }

    private void doCompare(Set<Delta> deltas, List<Map<String, Object>> firstProvidersData, List<Map<String, Object>> secondProvidersData, boolean reversed) {
        firstProvidersData.forEach(provider -> this.compareProvider(deltas, provider, this.findByEntityId(secondProvidersData, (String)String.class.cast(provider.get("entity_id"))), reversed));
    }

    private void compareProvider(Set<Delta> deltas, Map<String, Object> provider, Optional<Map<String, Object>> optionalProvider, boolean reversed) {
        Map otherProvider = optionalProvider.orElse(new HashMap());
        this.compareProvider(deltas, provider, otherProvider, reversed);
    }

    private void compareProvider(Set<Delta> deltas, Map<String, Object> provider, Map<String, Object> otherProvider, boolean reversed) {
        provider.forEach((key, value) -> {
            boolean stringNotEquals;
            Object otherValue = otherProvider.get(key);
            boolean bl = stringNotEquals = value instanceof String && otherValue instanceof String && !((String)String.class.cast(((String)value).trim())).equals(String.class.cast(((String)otherValue).trim()));
            if (stringNotEquals || !Objects.equals(value, otherValue)) {
                deltas.add(new Delta((String)String.class.cast(provider.get("entity_id")), key, reversed ? otherValue : value, reversed ? value : otherValue));
            }
        });
    }

    private Optional<Map<String, Object>> findByEntityId(List<Map<String, Object>> providersData, String entityId) {
        List providers = providersData.stream().filter(provider -> provider.get("entity_id").equals(entityId)).collect(Collectors.toList());
        return providers.isEmpty() ? Optional.empty() : Optional.of(providers.get(0));
    }
}

