/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import manage.format.Exporter;
import manage.model.MetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExportController {
    private List<String> excludeMetaDataOnlyKeys = Arrays.asList("allowedEntities", "arp", "disableConsent", "active", "manipulation");
    private Exporter exporter;
    private ObjectMapper objectMapper;

    @Autowired
    public ExportController(ObjectMapper objectMapper, ResourceLoader resourceLoader, @Value(value="${metadata_export_path}") String metadataExportPath) {
        this.objectMapper = objectMapper;
        this.exporter = new Exporter(Clock.systemDefaultZone(), resourceLoader, metadataExportPath);
    }

    @PostMapping(value={"/client/export"})
    public Map<String, Object> export(@RequestBody MetaData metaData) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        metaData.getData().entrySet().removeIf(entry -> entry.getValue() == null);
        Map nested = this.exporter.exportToMap(metaData, true);
        Map flat = this.exporter.exportToMap(metaData, false);
        ObjectWriter objectWriter = this.objectMapper.writerWithDefaultPrettyPrinter();
        result.put("json", objectWriter.writeValueAsString((Object)nested));
        result.put("jsonFlat", objectWriter.writeValueAsString((Object)flat));
        result.put("xml", this.exporter.exportToXml(metaData));
        TreeMap metaDataOnlyNested = new TreeMap(nested);
        this.excludeMetaDataOnlyKeys.forEach(metaDataOnlyNested::remove);
        result.put("jsonMetaDataOnly", objectWriter.writeValueAsString(metaDataOnlyNested));
        TreeMap metaDataOnlyFlat = new TreeMap(flat);
        this.excludeMetaDataOnlyKeys.forEach(metaDataOnlyFlat::remove);
        result.put("jsonMetaDataOnlyFlat", objectWriter.writeValueAsString(metaDataOnlyFlat));
        return result;
    }
}

