/*
 * Decompiled with CFR 0.152.
 */
package manage.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.WriteResult;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import manage.conf.MetaDataAutoConfiguration;
import manage.migration.ArpDeserializer;
import manage.migration.EntityType;
import manage.model.MetaData;
import manage.model.Revision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JanusMigration {
    private static final Logger LOG = LoggerFactory.getLogger(JanusMigration.class);
    private String keyColumn;
    private JdbcTemplate jdbcTemplate;
    private MongoTemplate mongoTemplate;
    private ArpDeserializer arpDeserializer = new ArpDeserializer();
    private MetaDataAutoConfiguration metaDataAutoConfiguration;

    @Autowired
    public JanusMigration(@Value(value="${key_column:key}") String keyColumn, DataSource dataSource, MongoTemplate mongoTemplate, MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.mongoTemplate = mongoTemplate;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.keyColumn = keyColumn;
    }

    public List<Map<String, Long>> doMigrate() {
        long start = System.currentTimeMillis();
        LinkedHashMap<String, Long> spStats = new LinkedHashMap<String, Long>();
        spStats.put("Number of SPs'", this.countForEntityType("janus__connection", EntityType.SP));
        spStats.put("Number of SP revisions", this.countForEntityType("janus__connectionRevision", EntityType.SP));
        spStats.put("Start migration of Service Providers", 0L);
        LinkedHashMap<String, Long> idpStats = new LinkedHashMap<String, Long>();
        idpStats.put("Number of IDPs'", this.countForEntityType("janus__connection", EntityType.IDP));
        idpStats.put("Number of IPD revisions", this.countForEntityType("janus__connectionRevision", EntityType.IDP));
        idpStats.put("Start migration of Identity Providers", 0L);
        this.emptyExistingCollections();
        this.saveEntities(EntityType.SP, spStats);
        LOG.info("Finished migration of SPs in {} ms and results {}", (Object)(System.currentTimeMillis() - start), (Object)this.prettyPrint(spStats));
        spStats.put("Finished migration of Service Providers in ms", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        this.saveEntities(EntityType.IDP, idpStats);
        LOG.info("Finished migration of IDPs in {} ms and results {}", (Object)(System.currentTimeMillis() - start), (Object)this.prettyPrint(idpStats));
        idpStats.put("Finished migration of Identity Providers in ms", System.currentTimeMillis() - start);
        return Arrays.asList(spStats, idpStats);
    }

    private Long countForEntityType(String table, EntityType entityType) {
        return (Long)this.jdbcTemplate.queryForObject("select count(*) from " + table + " where type = ?", new Object[]{entityType.getJanusDbValue()}, Long.class);
    }

    private String prettyPrint(Object obj) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void emptyExistingCollections() {
        Set schemaNames = this.metaDataAutoConfiguration.schemaNames();
        schemaNames.forEach(schema -> {
            WriteResult writeResult = this.mongoTemplate.remove(new Query(), schema);
            LOG.info("Deleted {} records from {}", (Object)writeResult.getN(), schema);
            String revisionSchema = schema.concat("_revision");
            writeResult = this.mongoTemplate.remove(new Query(), revisionSchema);
            LOG.info("Deleted {} records from {}", (Object)writeResult.getN(), (Object)revisionSchema);
        });
    }

    private void saveEntities(EntityType entityType, Map<String, Long> stats) {
        this.jdbcTemplate.query("SELECT CONNECTION.id, CONNECTION.revisionNr FROM janus__connection AS CONNECTION INNER JOIN janus__connectionRevision AS CONNECTION_REVISION ON CONNECTION_REVISION.eid = CONNECTION.id AND CONNECTION_REVISION.revisionid = CONNECTION.revisionNr WHERE CONNECTION.type=?", (Object[])new String[]{entityType.getJanusDbValue()}, rs -> this.saveEntity(Long.valueOf(rs.getLong("id")), Long.valueOf(rs.getLong("revisionNr")), entityType.getType(), true, null, stats, entityType));
    }

    private void saveEntity(Long eid, Long revisionid, String type, boolean isPrimary, String parentId, Map<String, Long> stats, EntityType entityType) {
        String sql = "SELECT janus__connectionRevision.id, janus__connectionRevision.eid, janus__connectionRevision.entityid, janus__connectionRevision.revisionid, janus__connectionRevision.state, janus__connectionRevision.metadataurl, janus__connectionRevision.allowedall,                janus__connectionRevision.manipulation, janus__user.userid, janus__connectionRevision.created,                 janus__connectionRevision.ip, janus__connectionRevision.revisionnote,                 janus__connectionRevision.active, janus__connectionRevision.arp_attributes,                 janus__connectionRevision.notes FROM janus__connectionRevision AS janus__connectionRevision                 LEFT OUTER JOIN janus__user AS janus__user ON janus__user.uid = janus__connectionRevision.user                 WHERE  janus__connectionRevision.eid = ? AND janus__connectionRevision.revisionid = ?";
        this.jdbcTemplate.query(sql, (Object[])new Long[]{eid, revisionid}, rs -> {
            LinkedHashMap<String, Object> entity = new LinkedHashMap<String, Object>();
            entity.put("id", rs.getLong("id"));
            entity.put("eid", rs.getLong("eid"));
            entity.put("entityid", rs.getString("entityid"));
            entity.put("revisionid", rs.getLong("revisionid"));
            entity.put("state", rs.getString("state"));
            entity.put("type", entityType.getJanusDbValue());
            entity.put("metadataurl", rs.getString("metadataurl"));
            entity.put("allowedall", rs.getString("allowedall").equals("yes"));
            entity.put("manipulation", rs.getString("manipulation"));
            String userid = rs.getString("userid");
            String user = StringUtils.hasText((String)userid) ? userid : "unknown";
            entity.put("user", user);
            entity.put("created", rs.getString("created"));
            entity.put("ip", rs.getString("ip"));
            entity.put("revisionnote", rs.getString("revisionnote"));
            entity.put("active", rs.getString("active").equals("yes"));
            if (type.equals(EntityType.SP.getType())) {
                entity.put("arp", this.arpDeserializer.parseArpAttributes(rs.getString("arp_attributes")));
            }
            entity.put("notes", rs.getString("notes"));
            this.addMetaData(entity, eid, revisionid, isPrimary, entityType);
            this.addAllowedEntities(entity, eid, revisionid);
            if (entityType.equals((Object)EntityType.IDP)) {
                this.addConsentDisabled(entity, eid, revisionid);
            }
            Instant instant = Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((String)entity.get("created")));
            String id = UUID.randomUUID().toString();
            MetaData metaData = new MetaData(id, Long.valueOf(0L), type, new Revision(revisionid.intValue(), instant, parentId, user), entity);
            this.mongoTemplate.insert((Object)metaData, type);
            String key = isPrimary ? entityType.getJanusDbValue() : entityType.getJanusDbValue() + "_revision";
            Long revisionCount = (Long)stats.get(key);
            stats.put(key, revisionCount == null ? 1L : revisionCount + 1L);
            if (isPrimary) {
                this.jdbcTemplate.query("SELECT eid, revisionid FROM janus__connectionRevision WHERE  eid = ? AND revisionid <> ?", (Object[])new Long[]{eid, revisionid}, rs2 -> {
                    long eid1 = rs2.getLong("eid");
                    long revisionid1 = rs2.getLong("revisionid");
                    this.saveEntity(Long.valueOf(eid1), Long.valueOf(revisionid1), type.concat("_revision"), false, id, stats, entityType);
                });
            }
        });
    }

    private void addMetaData(Map<String, Object> entity, Long eid, Long revisionid, boolean isPrimary, EntityType entityType) {
        this.jdbcTemplate.query("SELECT METADATA.`" + this.keyColumn + "`, METADATA.`value` FROM janus__connectionRevision AS CONNECTION_REVISION INNER JOIN janus__metadata AS METADATA ON METADATA.connectionRevisionId = CONNECTION_REVISION.id WHERE CONNECTION_REVISION.eid = ? AND CONNECTION_REVISION.revisionid = ?", (Object[])new Long[]{eid, revisionid}, rs -> this.parseMetaData(entity, rs.getString(this.keyColumn), rs.getString("value"), isPrimary, entityType));
    }

    private void addAllowedEntities(Map<String, Object> entity, Long eid, Long revisionid) {
        List allowedEntities = this.jdbcTemplate.queryForList("SELECT ALLOWED_CONNECTION.name AS entityid FROM janus__connectionRevision AS CONNECTION_REVISION INNER JOIN `janus__allowedConnection` a ON a.connectionRevisionId = CONNECTION_REVISION.id INNER JOIN janus__connection AS ALLOWED_CONNECTION ON ALLOWED_CONNECTION.id = a.remoteeid WHERE CONNECTION_REVISION.eid = ? AND CONNECTION_REVISION.revisionid = ?", (Object[])new Long[]{eid, revisionid}, String.class);
        entity.put("allowedEntities", this.stringToNameMap(allowedEntities));
    }

    private void addConsentDisabled(Map<String, Object> entity, Long eid, Long revisionid) {
        List disableConsent = this.jdbcTemplate.queryForList("SELECT ALLOWED_CONNECTION.name AS entityid FROM janus__connectionRevision AS CONNECTION_REVISION INNER JOIN janus__disableConsent disableConsent ON disableConsent.connectionRevisionId = CONNECTION_REVISION.id INNER JOIN janus__connection AS ALLOWED_CONNECTION ON ALLOWED_CONNECTION.id = disableConsent.remoteeid WHERE CONNECTION_REVISION.eid = ? AND CONNECTION_REVISION.revisionid = ?", (Object[])new Long[]{eid, revisionid}, String.class);
        entity.put("disableConsent", this.stringToNameMap(disableConsent));
    }

    private boolean keyIsPatternProperty(String key, Map<String, Object> patternProperties) {
        return patternProperties.keySet().stream().anyMatch(pattern -> Pattern.compile(pattern).matcher(key).matches());
    }

    private void parseMetaData(Map<String, Object> entity, String key, String value, boolean isPrimary, EntityType entityType) {
        if (StringUtils.hasText((String)value)) {
            value = value.trim();
            Map metaDataFields = entity.getOrDefault("metaDataFields", new HashMap());
            if (isPrimary) {
                Map schema = this.metaDataAutoConfiguration.schemaRepresentation(entityType);
                Map metaDataSchema = (Map)Map.class.cast(((Map)Map.class.cast(schema.get("properties"))).get("metaDataFields"));
                Map properties = (Map)Map.class.cast(metaDataSchema.get("properties"));
                Map patternProperties = (Map)Map.class.cast(metaDataSchema.get("patternProperties"));
                if (properties.containsKey(key) || this.keyIsPatternProperty(key, patternProperties)) {
                    if (Pattern.compile("^contacts:([0-3]{1}):emailAddress$").matcher(key).matches()) {
                        value = value.replaceAll(Pattern.quote("mailto:"), "");
                    }
                    metaDataFields.put(key, value);
                } else {
                    LOG.info("Not adding unknown property {} with value {} for entity {} with type {}", new Object[]{key, value, entity.get("entityid"), entityType.getType()});
                }
            } else {
                metaDataFields.put(key, value);
            }
            entity.put("metaDataFields", metaDataFields);
        }
    }

    private List<Map<String, String>> stringToNameMap(List<String> entityIds) {
        return entityIds.stream().map(s -> Collections.singletonMap("name", s)).collect(Collectors.toList());
    }
}

