/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.List;
import manage.hook.MetaDataHook;
import manage.model.MetaData;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CompositeMetaDataHook
implements MetaDataHook {
    private List<MetaDataHook> hooks;

    public CompositeMetaDataHook(List<MetaDataHook> hooks) {
        Assert.isTrue((!CollectionUtils.isEmpty(hooks) ? 1 : 0) != 0, (String)"Hooks may not be empty");
        this.hooks = hooks;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return true;
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        return this.hooks.stream().filter(hook -> hook.appliesForMetaData(newMetaData)).map(hook -> hook.prePut(previous, newMetaData)).findAny().orElse(newMetaData);
    }

    public MetaData prePost(MetaData metaData) {
        return this.hooks.stream().filter(hook -> hook.appliesForMetaData(metaData)).map(hook -> hook.prePost(metaData)).findAny().orElse(metaData);
    }

    public MetaData preDelete(MetaData metaData) {
        return this.hooks.stream().filter(hook -> hook.appliesForMetaData(metaData)).map(hook -> hook.preDelete(metaData)).findAny().orElse(metaData);
    }
}

