/*
 * Decompiled with CFR 0.152.
 */
package manage.migration;

import com.github.ooxi.phparser.SerializedPhpParser;
import com.github.ooxi.phparser.SerializedPhpParserException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class ArpDeserializer {
    private static final Map<String, Object> NO_ARP = new HashMap();

    public Map<String, Object> parseArpAttributes(String input) {
        Object parse;
        if (StringUtils.isEmpty((Object)input) || input.equalsIgnoreCase("N;")) {
            return NO_ARP;
        }
        SerializedPhpParser serializedPhpParser = new SerializedPhpParser(input);
        try {
            parse = serializedPhpParser.parse();
        }
        catch (SerializedPhpParserException e) {
            throw new RuntimeException(e);
        }
        Map arp = (Map)Map.class.cast(parse);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("enabled", true);
        HashMap attributes = new HashMap();
        result.put("attributes", attributes);
        arp.forEach((key, value) -> attributes.put(key, value.values().stream().map(arg_0 -> this.arpValue(arg_0)).collect(Collectors.toList())));
        return result;
    }

    private Map<String, String> arpValue(Object o) {
        if (o instanceof String) {
            String value = (String)String.class.cast(o);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("source", "idp");
            result.put("value", StringUtils.hasText((String)value) ? value : "*");
            return result;
        }
        Map map = (Map)o;
        map.compute("value", (key, oldValue) -> StringUtils.hasText((String)oldValue) ? oldValue : "*");
        map.compute("source", (key, oldValue) -> StringUtils.hasText((String)oldValue) ? oldValue : "idp");
        return map;
    }

    static {
        NO_ARP.put("enabled", false);
        NO_ARP.put("attributes", new HashMap());
    }
}

