/*
 * Decompiled with CFR 0.152.
 */
package manage.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import manage.model.MetaDataUpdate;
import manage.model.Revision;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.util.Assert;

public class MetaData
implements Serializable {
    @Id
    private String id;
    @Version
    private Long version;
    @NotNull
    private String type;
    private Revision revision;
    @NotNull
    private Map<String, Object> data;

    public MetaData(String type, Map<String, Object> data) {
        this.type = type;
        this.data = data;
    }

    public void initial(String id, String createdBy, Long eid) {
        this.id = id;
        this.revision = new Revision(0, Instant.now(), null, createdBy);
        this.data.put("eid", eid);
    }

    public void revision(String newId) {
        this.type = this.type.concat("_revision");
        this.getNonNullRevision().setParentId(this.id);
        this.id = newId;
    }

    public void terminate(String newId) {
        this.revision(newId);
        this.revision.terminate();
    }

    private Revision getNonNullRevision() {
        if (this.revision == null) {
            this.revision = new Revision(0, Instant.now(), null, "system");
        }
        return this.revision;
    }

    public void promoteToLatest(String updatedBy) {
        this.revision = new Revision(this.getNonNullRevision().getNumber() + 1, Instant.now(), null, updatedBy);
    }

    public void restoreToLatest(String newId, Long version, String updatedBy, int latestRevisionNumber, String newType) {
        this.type = newType;
        this.id = newId;
        this.version = version;
        this.getData().put("revisionnote", "Restore of revision: " + this.getNonNullRevision().getNumber());
        this.revision = new Revision(latestRevisionNumber + 1, Instant.now(), null, updatedBy);
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void merge(MetaDataUpdate metaDataUpdate) {
        metaDataUpdate.getPathUpdates().forEach((path, value) -> {
            List<String> parts = Arrays.asList(path.split("\\."));
            Iterator<String> iterator = parts.iterator();
            String part = iterator.next();
            Map reference = parts.size() == 1 ? this.data : this.data.get(part);
            String property = path;
            while (iterator.hasNext()) {
                Assert.notNull((Object)reference, (String)String.format("Invalid metadata path %s. %s part does not exists", value, part));
                part = iterator.next();
                if (iterator.hasNext()) {
                    reference = ((Map)Map.class.cast(reference)).get(part);
                    continue;
                }
                property = part;
            }
            ((Map)Map.class.cast(reference)).put(property, value);
        });
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public MetaData() {
    }

    public MetaData(String id, Long version, String type, Revision revision, Map<String, Object> data) {
        this.id = id;
        this.version = version;
        this.type = type;
        this.revision = revision;
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaData)) {
            return false;
        }
        MetaData other = (MetaData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

