/*
 * Decompiled with CFR 0.152.
 */
package manage.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import manage.model.MetaData;
import manage.mongo.Sequence;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MetaDataRepository {
    private static final int AUTOCOMPLETE_LIMIT = 15;
    private MongoTemplate mongoTemplate;

    @Autowired
    public MetaDataRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public MetaData findById(String id, String type) {
        return (MetaData)this.mongoTemplate.findById((Object)id, MetaData.class, type);
    }

    public MetaData save(MetaData metaData) {
        this.mongoTemplate.insert((Object)metaData, metaData.getType());
        return metaData;
    }

    public void remove(MetaData metaData) {
        this.mongoTemplate.remove((Object)metaData, metaData.getType());
    }

    public List<MetaData> revisions(String type, String parentId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"revision.parentId").is((Object)parentId));
        return this.mongoTemplate.find(query, MetaData.class, type);
    }

    public void update(MetaData metaData) {
        this.mongoTemplate.save((Object)metaData, metaData.getType());
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public List<Map> autoComplete(String type, String search) {
        Query query = this.queryWithSamlFields();
        if ("*".equals(search)) {
            return this.mongoTemplate.find(query, Map.class, type);
        }
        search = this.escapeSpecialChars(search);
        query.limit(15);
        Criteria criteria = new Criteria();
        query.addCriteria((CriteriaDefinition)criteria.orOperator(new Criteria[]{this.regex("data.entityid", search), this.regex("data.metaDataFields.name:en", search), this.regex("data.metaDataFields.name:nl", search), this.regex("data.metaDataFields.keywords:en", search), this.regex("data.metaDataFields.keywords:nl", search)}));
        return this.mongoTemplate.find(query, Map.class, type);
    }

    protected String escapeSpecialChars(String query) {
        return query.replaceAll("([\\Q\\/$^.?*+{}()|[]\\E]+)", "\\\\$1");
    }

    private Criteria regex(String key, String search) {
        try {
            return Criteria.where((String)key).regex(".*" + search + ".*", "i");
        }
        catch (IllegalArgumentException e) {
            return Criteria.where((String)"nope").exists(true);
        }
    }

    public List<Map> search(String type, Map<String, Object> properties, List<String> requestedAttributes, Boolean allAttributes, Boolean logicalOperatorIsAnd) {
        Query query;
        Query query2 = query = allAttributes != false ? new Query() : this.queryWithSamlFields();
        if (!allAttributes.booleanValue()) {
            requestedAttributes.forEach(requestedAttribute -> query.fields().include("data.".concat((String)requestedAttribute)));
        }
        ArrayList<Criteria> criteriaDefinitions = new ArrayList<Criteria>();
        properties.forEach((key, value) -> {
            if (value instanceof Boolean && ((Boolean)Boolean.class.cast(value)).booleanValue() && key.contains("attributes")) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).exists(true));
            } else if (value instanceof String && !StringUtils.hasText((String)((String)String.class.cast(value)))) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).exists(false));
            } else if ("*".equals(value)) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).regex(".*", "i"));
            } else if (value instanceof String && ((String)String.class.cast(value)).contains("*")) {
                String queryString = (String)String.class.cast(value);
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).regex(queryString, "i"));
            } else if (value instanceof List && !((List)List.class.cast(value)).isEmpty()) {
                List l = (List)List.class.cast(value);
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).in((Collection)l));
            } else {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).is(value));
            }
        });
        if (criteriaDefinitions.isEmpty()) {
            criteriaDefinitions.add(Criteria.where((String)"data").exists(true));
        }
        Criteria[] criteria = criteriaDefinitions.toArray(new Criteria[0]);
        if (logicalOperatorIsAnd.booleanValue()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(criteria));
        } else {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(criteria));
        }
        return this.mongoTemplate.find(query, Map.class, type);
    }

    public List<MetaData> findRaw(String type, String query) {
        return this.mongoTemplate.find((Query)new BasicQuery(query), MetaData.class, type);
    }

    public List<Map> whiteListing(String type) {
        Query query = this.queryWithSamlFields();
        query.fields().include("data.allowedall").include("data.allowedEntities");
        return this.mongoTemplate.find(query, Map.class, type);
    }

    public Long incrementEid() {
        Update updateInc = new Update();
        updateInc.inc("value", (Number)1L);
        Sequence res = (Sequence)this.mongoTemplate.findAndModify((Query)new BasicQuery("{\"_id\":\"sequence\"}"), updateInc, Sequence.class);
        return res.getValue();
    }

    private Query queryWithSamlFields() {
        Query query = new Query();
        query.fields().include("version").include("data.state").include("data.entityid").include("data.notes").include("data.metaDataFields.name:en").include("data.metaDataFields.name:nl");
        return query;
    }
}

