/*
 * Decompiled with CFR 0.152.
 */
package manage.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import manage.conf.IndexConfiguration;
import manage.migration.EntityType;
import manage.validations.BooleanFormatValidator;
import manage.validations.CertificateFormatValidator;
import manage.validations.NumberFormatValidator;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MetaDataAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataAutoConfiguration.class);
    private Map<String, Schema> schemas;
    private Map<String, Object> templates;
    private List<Map<String, Object>> schemaRepresentations = new ArrayList();
    private Map<String, List<IndexConfiguration>> indexConfigurations = new HashMap();
    private ObjectMapper objectMapper;

    @Autowired
    public MetaDataAutoConfiguration(ObjectMapper objectMapper, @Value(value="${metadata_configuration_path}") Resource metadataConfigurationPath, @Value(value="${metadata_templates_path}") Resource metadataTemplatesPath) throws IOException {
        this.schemas = this.parseConfiguration(metadataConfigurationPath, Arrays.asList(new CertificateFormatValidator(), new NumberFormatValidator(), new BooleanFormatValidator()));
        this.objectMapper = objectMapper;
        this.templates = this.parseTemplates(metadataTemplatesPath);
        LOG.info("Finished loading {} metadata configurations", (Object)this.schemas.size());
    }

    public void validate(String json, String type) {
        JSONObject jsonObject = new JSONObject(new JSONTokener(json));
        Schema schema = this.schemas.computeIfAbsent(type, key -> {
            throw new IllegalArgumentException(String.format("No schema defined for %s", key));
        });
        schema.validate((Object)jsonObject);
    }

    public Set<String> schemaNames() {
        return this.schemas.keySet();
    }

    public Object metaDataTemplate(String type) {
        return this.templates.computeIfAbsent(type, key -> {
            throw new IllegalArgumentException(String.format("No template defined for %s", key));
        });
    }

    public List<IndexConfiguration> indexConfigurations(String schemaType) {
        return this.indexConfigurations.getOrDefault(schemaType, Collections.emptyList());
    }

    public List<Map<String, Object>> schemaRepresentations() {
        return this.schemaRepresentations;
    }

    public Map<String, Object> schemaRepresentation(EntityType entityType) {
        Optional<Map> schemaRepresentationOptional = this.schemaRepresentations().stream().filter(map -> map.get("title").equals(entityType.getType())).findFirst();
        return schemaRepresentationOptional.orElseThrow(() -> new IllegalArgumentException(String.format("The %s schema does not exists", entityType.getType())));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private Map<String, Schema> parseConfiguration(Resource metadataConfigurationPath, List<FormatValidator> validators) throws IOException {
        Object[] schemaFiles = metadataConfigurationPath.getFile().listFiles((dir, name) -> name.endsWith("schema.json"));
        Assert.notEmpty((Object[])schemaFiles, (String)String.format("No schema.json files defined in %s", metadataConfigurationPath.getFilename()));
        return Arrays.stream(schemaFiles).map(file -> this.parse(file, validators)).collect(Collectors.toMap(Schema::getTitle, schema -> schema));
    }

    private Map<String, Object> parseTemplates(Resource metadataTemplatesPath) throws IOException {
        Object[] templates = metadataTemplatesPath.getFile().listFiles((dir, name) -> name.endsWith("template.json"));
        Assert.notEmpty((Object[])templates, (String)String.format("No template.json files defined in %s", metadataTemplatesPath.getFilename()));
        return Arrays.stream(templates).map(arg_0 -> this.parseTemplate(arg_0)).collect(Collectors.toMap(map -> (String)map.keySet().iterator().next(), map -> map.values().iterator().next()));
    }

    private Schema parse(File file, List<FormatValidator> validators) {
        JSONObject jsonObject;
        try {
            jsonObject = new JSONObject(new JSONTokener((InputStream)new FileInputStream(file)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s not found", file.getAbsolutePath()));
        }
        SchemaLoader.SchemaLoaderBuilder schemaLoaderBuilder = SchemaLoader.builder().schemaJson(jsonObject);
        validators.forEach(arg_0 -> ((SchemaLoader.SchemaLoaderBuilder)schemaLoaderBuilder).addFormatValidator(arg_0));
        Schema schema = schemaLoaderBuilder.build().load().build();
        this.addIndexes(schema.getTitle(), jsonObject);
        this.schemaRepresentations.add(jsonObject.toMap());
        return schema;
    }

    private Map<String, Object> parseTemplate(File file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Object template = this.objectMapper.readValue(file, Object.class);
            String name = file.getName();
            result.put(name.substring(0, name.indexOf(".template.json")), template);
            return result;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void addIndexes(String schemaType, JSONObject json) {
        if (json.has("indexes")) {
            List indexes = json.getJSONArray("indexes").toList();
            List indexConfigurations = indexes.stream().map(obj -> {
                Map map = (Map)Map.class.cast(obj);
                return new IndexConfiguration((String)map.get("name"), (String)map.get("type"), (List)map.get("fields"), ((Boolean)map.get("unique")).booleanValue());
            }).collect(Collectors.toList());
            this.indexConfigurations.put(schemaType, indexConfigurations);
        }
    }
}

