/*
 * Decompiled with CFR 0.152.
 */
package manage;

import java.sql.SQLException;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.Assert;

@Configuration
public class DataSourceConfiguration {
    @Bean
    @Primary
    @ConfigurationProperties(value="spring.datasource")
    public DataSourceProperties srDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean(value={"dataSource"})
    @Primary
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource srDataSource() throws SQLException {
        return this.initDataSource(this.srDataSourceProperties());
    }

    @Bean
    @ConfigurationProperties(value="eb.datasource")
    public DataSourceProperties ebDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean(value={"ebDataSource"})
    @ConfigurationProperties(prefix="eb.datasource")
    public DataSource ebDataSource() {
        return this.initDataSource(this.ebDataSourceProperties());
    }

    private DataSource initDataSource(DataSourceProperties dataSourceProperties) {
        DataSource dataSource = (DataSource)dataSourceProperties.initializeDataSourceBuilder().type(DataSource.class).build();
        this.setTypeSpecificProperties(dataSource);
        return dataSource;
    }

    private void setTypeSpecificProperties(DataSource tomcatDataSource) {
        tomcatDataSource.setTestOnBorrow(true);
        tomcatDataSource.setValidationQuery("SELECT 1");
        tomcatDataSource.setRemoveAbandoned(true);
        tomcatDataSource.setTestWhileIdle(true);
        tomcatDataSource.setLogValidationErrors(true);
        ConnectionPool pool = tomcatDataSource.getPool();
        Assert.notNull((Object)pool, (String)"Tomcat datasource pool is null");
    }
}

