/*
 * Decompiled with CFR 0.152.
 */
package manage.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import manage.conf.MetaDataAutoConfiguration;
import manage.migration.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JanusMigrationValidation {
    private static final Logger LOG = LoggerFactory.getLogger(JanusMigrationValidation.class);
    private MetaDataRepository metaDataRepository;
    private MetaDataAutoConfiguration metaDataAutoConfiguration;

    @Autowired
    public JanusMigrationValidation(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public Map<String, Object> validateMigration() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Stream.of(EntityType.values()).map(EntityType::getType).forEach(type -> this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, type).stream().forEach(metaData -> this.validate(metaData, type, results)));
        return results;
    }

    private void validate(MetaData metaData, String type, Map<String, Object> results) {
        if (((Map)Map.class.cast(metaData.getData())).get("state").equals("testaccepted")) {
            return;
        }
        try {
            String json = this.metaDataAutoConfiguration.getObjectMapper().writeValueAsString((Object)metaData.getData());
            this.metaDataAutoConfiguration.validate(json, type);
        }
        catch (ValidationException e) {
            Map data = (Map)Map.class.cast(metaData.getData());
            Map resultsMap = e.toJSON().toMap();
            LOG.info("ValidationException for id {} eid {} entityId {} type {} with exception {}", new Object[]{data.get("id"), data.get("eid"), data.get("entityid"), type, resultsMap});
            results.put((String)String.class.cast(data.get("entityid")), resultsMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

