/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mongobee.Mongobee;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import manage.conf.IndexConfiguration;
import manage.conf.MetaDataAutoConfiguration;
import manage.migration.EntityType;
import manage.model.MetaData;
import manage.mongo.TypeOfService;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

@Configuration
@ChangeLog
public class MongobeeConfiguration {
    public static final String REVISION_POSTFIX = "_revision";
    private static final Logger LOG = LoggerFactory.getLogger(MongobeeConfiguration.class);
    private static MetaDataAutoConfiguration staticMetaDataAutoConfiguration;
    @Autowired
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    @Autowired
    private MappingMongoConverter mongoConverter;

    @PostConstruct
    public void setUpMongoEscapeCharacterConversion() {
        this.mongoConverter.setMapKeyDotReplacement("@");
    }

    @Bean
    public Mongobee mongobee(@Value(value="${spring.data.mongodb.uri}") String uri) {
        Mongobee runner = new Mongobee(uri);
        runner.setChangeLogsScanPackage("manage.mongo");
        staticMetaDataAutoConfiguration = this.metaDataAutoConfiguration;
        return runner;
    }

    @ChangeSet(order="001", id="createCollections", author="Okke Harsta", runAlways=true)
    public void createCollections(MongoTemplate mongoTemplate) {
        Set schemaNames = staticMetaDataAutoConfiguration.schemaNames();
        schemaNames.forEach(schema -> {
            if (!mongoTemplate.collectionExists(schema)) {
                mongoTemplate.createCollection(schema);
                staticMetaDataAutoConfiguration.indexConfigurations(schema).stream().map(arg_0 -> this.indexDefinition(arg_0)).forEach(arg_0 -> ((IndexOperations)mongoTemplate.indexOps(schema)).ensureIndex(arg_0));
                String revision = schema.concat(REVISION_POSTFIX);
                mongoTemplate.createCollection(revision);
                mongoTemplate.indexOps(revision).ensureIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
            }
        });
    }

    @ChangeSet(order="002", id="createSingleTenantTemplates", author="Okke Harsta")
    public void createSingleTenantTemplates(MongoTemplate mongoTemplate) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath:single_tenant_templates/*.json");
        AtomicLong id = new AtomicLong();
        Arrays.asList(resources).forEach(res -> this.createSingleTenantTemplate(mongoTemplate, res, objectMapper, Long.valueOf(id.incrementAndGet())));
    }

    @ChangeSet(order="003", id="reCreateSingleTenantTemplates", author="Okke Harsta")
    public void reCreateSingleTenantTemplates(MongoTemplate mongoTemplate) throws IOException {
        mongoTemplate.findAllAndRemove(new Query(), "single_tenant_template");
        mongoTemplate.findAllAndRemove(new Query(), "single_tenant_template_revision");
        this.createSingleTenantTemplates(mongoTemplate);
    }

    @ChangeSet(order="004", id="importCSA", author="Okke Harsta")
    public void importCsaSettings(MongoTemplate mongoTemplate) throws Exception {
        this.doImportCsaSettings(mongoTemplate);
    }

    @ChangeSet(order="005", id="reImportCSA", author="Okke Harsta", runAlways=false)
    public void reImportCsaSettings(MongoTemplate mongoTemplate) throws Exception {
        this.doImportCsaSettings(mongoTemplate);
    }

    private void doImportCsaSettings(MongoTemplate mongoTemplate) throws IOException {
        String type = EntityType.SP.getType();
        String content = IOUtils.toString((InputStream)new ClassPathResource("csa_export/csp.csv").getInputStream(), (Charset)Charset.defaultCharset());
        List<String> lines = Arrays.asList(content.split("\n"));
        HashMap<String, String> mappedLicenseStatus = new HashMap<String, String>();
        mappedLicenseStatus.put("HAS_LICENSE_SP", "license_required_by_service_provider");
        mappedLicenseStatus.put("NOT_NEEDED", "license_not_required");
        mappedLicenseStatus.put("HAS_LICENSE_SURFMARKET", "license_available_through_surfmarket");
        mappedLicenseStatus.put("UNKNOWN", "license_required_by_service_provider");
        lines.forEach(l -> {
            List<String> columns = Arrays.asList(l.split(","));
            String entityId = columns.get(0);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.entityid").is((Object)entityId));
            List metaDatas = mongoTemplate.find(query, MetaData.class, type);
            if (metaDatas != null && metaDatas.size() > 0) {
                MetaData metaData = (MetaData)metaDatas.get(0);
                Map metaDataFields = (Map)metaData.getData().get("metaDataFields");
                metaDataFields.put("coin:privacy:gdpr_is_in_wiki", columns.get(1));
                String licenseStatus = mappedLicenseStatus.getOrDefault(columns.get(2), "license_required_by_service_provider");
                metaDataFields.put("coin:license_status", licenseStatus);
                metaDataFields.put("coin:supports_strong_authentication", columns.get(3));
                metaDataFields.remove("coin:requires_strong_authentication");
                MetaData previous = (MetaData)mongoTemplate.findById((Object)metaData.getId(), MetaData.class, type);
                previous.revision(UUID.randomUUID().toString());
                mongoTemplate.insert((Object)previous, previous.getType());
                metaData.promoteToLatest("CSA import migration");
                mongoTemplate.save((Object)metaData, metaData.getType());
                LOG.info("Migrated {} to new revision in CSA import", (Object)entityId);
            }
        });
    }

    @ChangeSet(order="006", id="addValueToDisableConsent", author="Okke Harsta")
    public void addValueToDisableConsent(MongoTemplate mongoTemplate) throws Exception {
        List allIdPs = mongoTemplate.findAll(MetaData.class, EntityType.IDP.getType());
        allIdPs.forEach(idp -> idp.getData().getOrDefault("disableConsent", new ArrayList()).forEach(dc -> {
            dc.put("type", "no_consent");
            dc.put("explanation", "");
        }));
        allIdPs.stream().filter(idp -> !((List)List.class.cast(idp.getData().getOrDefault("disableConsent", new ArrayList()))).isEmpty()).forEach(idp -> {
            MetaData previous = (MetaData)mongoTemplate.findById((Object)idp.getId(), MetaData.class, EntityType.IDP.getType());
            previous.revision(UUID.randomUUID().toString());
            mongoTemplate.insert((Object)previous, previous.getType());
            idp.promoteToLatest("Add type / explanation to disableConsent entries");
            mongoTemplate.save(idp, idp.getType());
            LOG.info("Migrated {} to new revision in CSA import", idp.getData().get("entityid"));
        });
    }

    @ChangeSet(order="007", id="importFacetsInformation", author="Okke Harsta")
    public void importFacetsInformation(MongoTemplate mongoTemplate) throws IOException {
        String type = EntityType.SP.getType();
        String content = IOUtils.toString((InputStream)new ClassPathResource("csa_export/facets.csv").getInputStream(), (Charset)Charset.defaultCharset());
        List<String> lines = Arrays.asList(content.split("\n"));
        Map<String, List<TypeOfService>> typeOfServices = lines.stream().map(s -> {
            List<String> columns = Arrays.asList(s.split(","));
            return new TypeOfService(columns.get(0), columns.get(1), columns.get(2));
        }).collect(Collectors.groupingBy(TypeOfService::getLang));
        Map<String, List<TypeOfService>> nl = typeOfServices.get("nl").stream().collect(Collectors.groupingBy(TypeOfService::getEntityId));
        Map<String, List<TypeOfService>> en = typeOfServices.get("en").stream().collect(Collectors.groupingBy(TypeOfService::getEntityId));
        this.addTypeOfService(mongoTemplate, type, nl, "nl");
        this.addTypeOfService(mongoTemplate, type, en, "en");
    }

    @ChangeSet(order="008", id="addEIDToNewEntities", author="Okke Harsta", runAlways=true)
    public void addEIDToNewEntitiesToParents(MongoTemplate mongoTemplate) throws IOException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.eid").exists(false));
        Arrays.asList(EntityType.values()).forEach(type -> {
            String collectionName = type.getType();
            List parentProviders = mongoTemplate.find(query, Map.class, collectionName);
            parentProviders.forEach(provider -> {
                long eid = this.highestEid(mongoTemplate, collectionName) + 1L;
                ((Map)Map.class.cast(provider.get("data"))).put("eid", eid);
                mongoTemplate.save(provider, collectionName);
                LOG.info("Add eid {} to parent provider {}", (Object)eid, provider.get("_id"));
            });
        });
    }

    @ChangeSet(order="009", id="addEIDToNewEntitiesToRevisions", author="Okke Harsta", runAlways=true)
    public void addEIDToNewEntitiesToChildren(MongoTemplate mongoTemplate) throws IOException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.eid").exists(false));
        HashMap parentIdToEidMap = new HashMap();
        Arrays.asList(EntityType.values()).forEach(type -> {
            String collectionName = type.getType().concat(REVISION_POSTFIX);
            List childProviders = mongoTemplate.find(query, Map.class, collectionName);
            childProviders.forEach(childProvider -> {
                Map revision = (Map)Map.class.cast(childProvider.get("revision"));
                Object parentId = revision.get("parentId");
                Map parent = (Map)mongoTemplate.findById(parentId, Map.class, type.getType());
                if (parent != null) {
                    Object eid = ((Map)Map.class.cast(parent.get("data"))).get("eid");
                    Map childData = (Map)Map.class.cast(childProvider.get("data"));
                    childData.put("eid", eid);
                    mongoTemplate.save(childProvider, collectionName);
                    LOG.info("Add eid {} to child provider {}", eid, childProvider.get("_id"));
                } else {
                    long eid;
                    if (parentIdToEidMap.containsKey(parentId)) {
                        LOG.info("Re-using new eid for child provider {} because parent {} is deleted", childProvider.get("_id"), parentId);
                        eid = (Long)parentIdToEidMap.get(parentId);
                    } else {
                        eid = this.highestEid(mongoTemplate, collectionName) + 1L;
                        LOG.info("Calculating new eid for child provider {} because parent {} is deleted", childProvider.get("_id"), parentId);
                        parentIdToEidMap.put(parentId, eid);
                    }
                    Map childData = (Map)Map.class.cast(childProvider.get("data"));
                    childData.put("eid", eid);
                    mongoTemplate.save(childProvider, collectionName);
                    LOG.info("Add new eid {} to child provider {}", (Object)eid, childProvider.get("_id"));
                }
            });
        });
    }

    @ChangeSet(order="010", id="renameRequiresToSupportsStepUp", author="Okke Harsta")
    public void renameRequiresToSupportsStepUp(MongoTemplate mongoTemplate) throws IOException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.metaDataFields.coin:requires_strong_authentication").exists(true));
        List entities = mongoTemplate.find(query, MetaData.class, EntityType.SP.getType());
        entities.forEach(entity -> {
            Map metaDataFields = (Map)entity.getData().get("metaDataFields");
            Object supportsStrongAuthentication = metaDataFields.get("coin:requires_strong_authentication");
            metaDataFields.put("coin:supports_strong_authentication", supportsStrongAuthentication);
            metaDataFields.remove("coin:requires_strong_authentication");
            LOG.info("Saving metadata {} with supports_strong_authentication", (Object)entity.getId());
            mongoTemplate.save(entity, EntityType.SP.getType());
        });
    }

    private Long highestEid(MongoTemplate mongoTemplate, String type) {
        Query query = new Query().limit(1).with(new Sort(Sort.Direction.DESC, new String[]{"data.eid"}));
        query.fields().include("data.eid");
        Map res = (Map)mongoTemplate.findOne(query, Map.class, type);
        return Long.valueOf(((Map)Map.class.cast(res.get("data"))).get("eid").toString());
    }

    private void addTypeOfService(MongoTemplate mongoTemplate, String type, Map<String, List<TypeOfService>> nl, String lang) {
        nl.keySet().forEach(entityId -> {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.entityid").is(entityId));
            List metaDatas = mongoTemplate.find(query, MetaData.class, type);
            if (metaDatas != null && metaDatas.size() > 0) {
                MetaData metaData = (MetaData)metaDatas.get(0);
                Map metaDataFields = (Map)metaData.getData().get("metaDataFields");
                metaDataFields.put("coin:type_of_service:" + lang, ((List)nl.get(entityId)).stream().map(TypeOfService::getValue).collect(Collectors.toSet()).stream().collect(Collectors.joining(",")));
                MetaData previous = (MetaData)mongoTemplate.findById((Object)metaData.getId(), MetaData.class, type);
                previous.revision(UUID.randomUUID().toString());
                mongoTemplate.insert((Object)previous, previous.getType());
                metaData.promoteToLatest("CSA facet import migration");
                mongoTemplate.save((Object)metaData, metaData.getType());
                LOG.info("Migrated {} to new revision in CSA import", entityId);
            }
        });
    }

    private void createSingleTenantTemplate(MongoTemplate mongoTemplate, Resource resource, ObjectMapper objectMapper, Long currentEid) {
        Map template = this.readTemplate(resource, objectMapper);
        HashMap data = new HashMap();
        data.put("entityid", template.get("entityid"));
        data.put("state", template.get("workflowState"));
        HashMap<String, Serializable> arp = new HashMap<String, Serializable>();
        data.put("arp", arp);
        boolean enabled = template.containsKey("attributes");
        arp.put("enabled", Boolean.valueOf(enabled));
        HashMap attributes = new HashMap();
        if (enabled) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("source", "idp");
            source.put("value", "*");
            List values = Collections.singletonList(source);
            ((List)List.class.cast(template.get("attributes"))).forEach(attr -> attributes.put(((String)attr).replaceAll("\\.", "@"), values));
        }
        arp.put("attributes", attributes);
        Arrays.asList("entityid", "workflowState", "attributes").forEach(none -> template.remove(none));
        template.keySet().forEach(key -> {
            if (key.contains(".")) {
                template.put(key.replaceAll("\\.", "@"), template.get(key));
                template.remove(key);
            }
        });
        data.put("metaDataFields", template);
        MetaData metaData = new MetaData("single_tenant_template", data);
        metaData.initial(UUID.randomUUID().toString(), "auto-generated", currentEid);
        mongoTemplate.insert((Object)metaData, metaData.getType());
    }

    private Map<String, Object> readTemplate(Resource resource, ObjectMapper objectMapper) {
        Map template;
        try {
            template = (Map)objectMapper.readValue(resource.getInputStream(), Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return template;
    }

    private IndexDefinition indexDefinition(IndexConfiguration indexConfiguration) {
        Index index = new Index();
        indexConfiguration.getFields().forEach(field -> index.on("data.".concat((String)field), Sort.Direction.ASC));
        index.named(indexConfiguration.getName());
        if (indexConfiguration.isUnique()) {
            index.unique();
        }
        return index;
    }
}

