/*
 * Decompiled with CFR 0.152.
 */
package manage.mail;

import manage.mail.DefaultMailBox;
import manage.mail.MailBox;
import manage.mail.MockMailBox;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;

@Configuration
public class MailConfiguration {
    @Value(value="${email.base_url}")
    private String baseUrl;
    @Value(value="${email.from}")
    private String emailFrom;
    @Value(value="${email.to}")
    private String emailTo;

    @Bean
    @Primary
    @Profile(value={"test", "acc", "prod", "mail"})
    public MailBox mailSenderProd() {
        return new DefaultMailBox(this.baseUrl, this.emailTo, this.emailFrom);
    }

    @Bean
    @Profile(value={"dev"})
    public MailBox mailSenderDev() {
        return new MockMailBox(this.baseUrl, this.emailTo, this.emailFrom);
    }
}

